% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.design.pars.R
\name{gen.design.pars}
\alias{gen.design.pars}
\title{Generate optimal design parameters using ant colony optimization}
\usage{
gen.design.pars(
  dist.mean,
  dist.rank,
  n.of.ants,
  nl,
  q = 1e-04,
  n.of.archive = 100,
  xi = 0.5
)
}
\arguments{
\item{dist.mean}{List of means - coordinates}

\item{dist.rank}{Rank of the archived values of the objective function(s)}

\item{n.of.ants}{The number of artificial ants in the search.}

\item{nl}{Neighborhood of the search area}

\item{q}{The locality of the search (0, 1)}

\item{n.of.archive}{The number of the solution archive.}

\item{xi}{The convergence pressure (0, Inf)}
}
\value{
Generated optimal design parameter value(s) (i.e., a matrix with n.of.ants
    rows and n.of.design.pars columns)
}
\description{
This function can generate a set of optimal design parameters
    based on given distributions of the rank of optimization target
    (or budget).
}
\references{
Socha, K., & Dorigo, M. (2008). Ant colony optimization for
  continuous domains. European Journal of Operational Research,
  185(3), 1155-1173.

  We thank Dr. Krzysztof Socha for providing us the
  original code (https://iridia.ulb.ac.be/supp/IridiaSupp2008-001/)
  for this function.
}
