% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_trial_report.R
\name{make_trial_report}
\alias{make_trial_report}
\title{Create trial design report}
\usage{
make_trial_report(td, folder_path, trial_name = NA, keep_rmd = FALSE)
}
\arguments{
\item{td}{trial design created by assign_rates()}

\item{folder_path}{(character) path to the folder in which the report will be saved}

\item{trial_name}{(character) name of trial to be used in report}

\item{keep_rmd}{(logical) If FALSE (Default), the original rmd file will be deleted upon creating an html report. Otherwise, the rmd file will be saved in the folder specified by `folder_path`.}
}
\value{
path to the resulting html file (invisible)
}
\description{
This function creates an html report describing the trial design created by the user with assign_rates() and includes figures showing machine alignment
}
\examples{
#--- load experiment made by assign_rates() ---#
\donttest{
data(td_single_input)
make_trial_report(
  td = td_single_input,
  folder_path = tempdir()
)
}
}
