% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.session.R
\name{opal.session_running}
\alias{opal.session_running}
\title{Check if the R session is running}
\usage{
opal.session_running(opal)
}
\arguments{
\item{opal}{Opal object.}
}
\value{
A logical value.
}
\description{
Check if the remote R session is running and ready to receive R commands. 
Fails if the session does not exist.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.session(o, wait = FALSE)
ready <- opal.session_running(o)
while(!ready) {
  Sys.sleep(1)
  ready <- opal.session_running(o)
  cat(".")
}
opal.session_get(o)
opal.logout(o)
}
}
\seealso{
Other session functions: 
\code{\link{opal.session}()},
\code{\link{opal.session_delete}()},
\code{\link{opal.session_events}()},
\code{\link{opal.session_exists}()},
\code{\link{opal.session_get}()}
}
\concept{session functions}
