% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_cell_style}
\alias{wb_cell_style}
\alias{wb_get_cell_style}
\alias{wb_set_cell_style}
\alias{wb_set_cell_style_across}
\title{Apply styling to a cell region}
\usage{
wb_get_cell_style(wb, sheet = current_sheet(), dims)

wb_set_cell_style(wb, sheet = current_sheet(), dims, style)

wb_set_cell_style_across(
  wb,
  sheet = current_sheet(),
  style,
  cols = NULL,
  rows = NULL
)
}
\arguments{
\item{wb}{A \code{wbWorkbook} object}

\item{sheet}{sheet}

\item{dims}{A cell range in the worksheet}

\item{style}{A style or a cell with a certain style}

\item{cols}{The columns the style will be applied to, either "A:D" or 1:4}

\item{rows}{The rows the style will be applied to}
}
\value{
A named vector with cell style index positions
}
\description{
Setting a style across only impacts cells that are not yet part of a workbook. The effect is similar to setting the cell style for all cells in a row independently, though much quicker and less memory consuming.
}
\examples{
# set a style in b1
wb <- wb_workbook()$add_worksheet()$
  add_numfmt(dims = "B1", numfmt = "#,0")

# get style from b1 to assign it to a1
numfmt <- wb$get_cell_style(dims = "B1")

# assign style to a1
wb$set_cell_style(dims = "A1", style = numfmt)

# set style across a workbook
wb <- wb_workbook() \%>\%
  wb_add_worksheet() \%>\%
  wb_add_fill(dims = "C3", color = wb_color("yellow")) \%>\%
  wb_set_cell_style_across(style = "C3", cols = "C:D", rows = 3:4)
}
\seealso{
Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_cell_style}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_font}()},
\code{\link{wb_add_named_style}()},
\code{\link{wb_add_numfmt}()}
}
\concept{styles}
