% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OX2.R
\name{vectorized-ox}
\alias{vectorized-ox}
\alias{OX}
\alias{XO}
\title{Vectorized \code{ox}}
\usage{
OX(.f, ..., .then = list(...)[[1]], .else = rev(list(...))[[1]])

XO(.f, ..., .then = list(...)[[1]], .else = rev(list(...))[[1]])
}
\arguments{
\item{.f}{(\code{function})\cr
evaluated as \code{.f(...)}. Must return a vector of indices (\code{logical} or \code{integer}),
which defines which values will be replaced by \code{.else}.}

\item{...}{arguments passed to the \code{.f}.}

\item{.then}{(\code{list}, \code{atomic}, \code{NULL})\cr
A positive-replacement.
NOTE, that if \code{.then} is not specified directly by named argument then the
first argument from \code{...} will be taken.}

\item{.else}{(\code{list}, \code{atomic}, \code{NULL})\cr
A negative-replacement. Should be of length equal to length of \code{.then}, or
single value or \code{NULL}.
NOTE, that if \code{.else} is not specified directly by named argument then the
last argument from \code{...} will be considered as a replacement.}
}
\value{
\code{atomic} or \code{list}. Returned object is a \code{.then} object with elements
replaced by \code{.else} depending on a result of the logical condition.
}
\description{
Switch the values of the vector by another on specific indices.
}
\details{
\if{html}{\figure{uml2.jpg}{options: width="75\%" alt="Figure: uml2.jpg"}}
\if{latex}{\figure{uml2.jpg}{options: width=7cm}}

#' \code{OX} evaluates function \code{.f} which returns a vector of indices which
are then decide which values of \code{.then} are replaced by \verb{else}.\preformatted{.then[!idx] <- .else[!idx]
}

Consequence of above is that \code{idx = .f(...)} should be a \code{logical} vector or
\code{integer} vector which would be valid indices for \code{.then} and \code{.else}.
This means that \code{.then} and \code{.else} should be of the same length, but there
are two exceptions:
\itemize{
\item when \code{.else} is a single value, than this value will replace \code{.then} at
returned indices \code{.then[!idx] <- .else}
\item when \code{.else} is \code{NULL}
}

To invert the switch one can use \code{XO} which is equivalent of
\code{OX(Negate(.f), ..., .then, .else)}.
}
\examples{
# switch values of the vector when condition is true
OX(is.na, c(1, NA, 3), .else = c(2, 2, 2))

# use OX to invert negate the condition
XO(is.na, c(1, NA, 3), .else = c(2, 2, 2))
}
