% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableOption.R
\name{tableOption}
\alias{tableOption}
\alias{find_posOption}
\alias{posOption}
\alias{posOption<-}
\alias{find_widthOption}
\alias{widthOption}
\alias{widthOption<-}
\alias{find_columnOptions}
\alias{columnOptions}
\alias{columnOptions<-}
\title{Functions related to table options.}
\usage{
find_posOption(table)

posOption(table)

posOption(table, asis = FALSE) <- value

find_widthOption(table)

widthOption(table)

widthOption(table, asis = FALSE) <- value

find_columnOptions(table)

columnOptions(table)

columnOptions(table, asis = FALSE) <- value
}
\arguments{
\item{table}{A known tabular-like environment object,
or the contents of one.}

\item{asis}{Whether to make small modifications in replacement functions.}

\item{value}{A character string or \link{LaTeX2} object.}
}
\value{
\code{find_posOption()} returns the indices of the
entries corresponding to the "pos" option, including the
brackets, within the table.

\code{posOption()} returns a \link{LaTeX2} object containing the
"pos" option.

\code{find_widthOption()} returns the index of the
block corresponding to the "width" option, if there is one.
Only some tabular-like environments have these.

\code{widthOption()} returns a \link{LaTeX2} object containing the
"width" option, if the table has one.

\code{find_columnOptions()} returns the index of the
block corresponding to the column spec.

\code{columnOptions()} returns a \link{LaTeX2} object containing the
"column" options.
}
\description{
Functions related to table options.
}
\details{
Unless \code{asis == TRUE}, the value for \code{value} in \code{posOption(table) <- value}
can be specified with or without the enclosing brackets.
}
\examples{
latex <- kableExtra::kbl(mtcars[1:2, 1:2], format = "latex")
parsed <- parseLatex(latex)
table <- parsed[[find_tabular(parsed)]]
table
find_posOption(table)

posOption(table)

posOption(table) <- "h"
posOption(table)
find_widthOption(table)

widthOption(table)

find_columnOptions(table)
columnOptions(table)

columnOptions(table) <- "lrr"
table
}
