% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{wallaceI}
\alias{wallaceI}
\alias{wallaceI,Partition,Partition-method}
\alias{wallaceI,PairCoefficients,missing-method}
\title{Wallace I}
\usage{
wallaceI(p, q)

\S4method{wallaceI}{Partition,Partition}(p, q)

\S4method{wallaceI}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute Wallace' index I
\deqn{\frac{N_{11}}{N_{21}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
isTRUE(all.equal(wallaceI(new("Partition", c(0, 0, 0, 1, 1)), 
                          new("Partition", c(0, 0, 1, 1, 1))), 0.5))

}
\references{
\insertRef{Wallace1983}{partitionComparison}
}
\seealso{
\code{\link{folwkesMallowsIndex}}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
