% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_import_functions.R
\name{read_flydra_mat}
\alias{read_flydra_mat}
\title{Import data from a MAT file exported from Flydra software}
\usage{
read_flydra_mat(mat_file, file_id = NA, subject_name, frame_rate = 100, ...)
}
\arguments{
\item{mat_file}{A file (or path to file) in .mat format, exported from Flydra}

\item{file_id}{(Optional) identifier for this file. If not supplied, this
defaults to \code{basename(file_name)}.}

\item{subject_name}{Name that will be assigned to the subject}

\item{frame_rate}{The capture frame rate of the session}

\item{...}{Additional arguments that may be passed from other pathviewr
functions}
}
\value{
A tibble with numerical data in columns. The first two columns will
have frame numbers and time (assumed to be in secs), respectively. Columns
3 through 5 will contain position data. Note that unlike the behavior of
\code{read_motive_csv()} this function produces "tidy" data that have
already been gathered into key-value pairs based on subject.
}
\description{
\code{read_flydra_mat()} is designed to import data from a \code{.mat} file
that has been exported from Flydra software. The resultant object is a tibble
that additionally has important metadata stored as attributes (see Details).
}
\examples{
library(pathviewr)

## Import the example Flydra data included in the package
flydra_data <-
  read_flydra_mat(system.file("extdata", "pathviewr_flydra_example_data.mat",
                             package = 'pathviewr'),
                  subject_name = "birdie_wooster")

## Names of variables in the resulting tibble
names(flydra_data)

## A variety of metadata are stored as attributes. Of particular interest:
attr(flydra_data, "pathviewr_steps")
}
\seealso{
\code{\link{read_motive_csv}} for importing Motive data

Other data import functions: 
\code{\link{as_viewr}()},
\code{\link{import_and_clean_batch}()},
\code{\link{import_batch}()},
\code{\link{read_motive_csv}()}
}
\author{
Vikram B. Baliga
}
\concept{data import functions}
