% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_tags}
\alias{costexplorer_get_tags}
\title{Queries for available tag keys and tag values for a specified period}
\usage{
costexplorer_get_tags(
  SearchString = NULL,
  TimePeriod,
  TagKey = NULL,
  Filter = NULL,
  SortBy = NULL,
  BillingViewArn = NULL,
  MaxResults = NULL,
  NextPageToken = NULL
)
}
\arguments{
\item{SearchString}{The value that you want to search for.}

\item{TimePeriod}{[required] The start and end dates for retrieving the dimension values. The start
date is inclusive, but the end date is exclusive. For example, if
\code{start} is \code{2017-01-01} and \code{end} is \code{2017-05-01}, then the cost and
usage data is retrieved from \code{2017-01-01} up to and including
\code{2017-04-30} but not including \code{2017-05-01}.}

\item{TagKey}{The key of the tag that you want to return values for.}

\item{Filter}{}

\item{SortBy}{The value that you want to sort the data by.

The key represents cost and usage metrics. The following values are
supported:
\itemize{
\item \code{BlendedCost}
\item \code{UnblendedCost}
\item \code{AmortizedCost}
\item \code{NetAmortizedCost}
\item \code{NetUnblendedCost}
\item \code{UsageQuantity}
\item \code{NormalizedUsageAmount}
}

The supported values for \code{SortOrder} are \code{ASCENDING} and \code{DESCENDING}.

When you use \code{SortBy}, \code{NextPageToken} and \code{SearchString} aren't
supported.}

\item{BillingViewArn}{The Amazon Resource Name (ARN) that uniquely identifies a specific
billing view. The ARN is used to specify which particular billing view
you want to interact with or retrieve information from when making API
calls related to Amazon Web Services Billing and Cost Management
features. The BillingViewArn can be retrieved by calling the
ListBillingViews API.}

\item{MaxResults}{This field is only used when SortBy is provided in the request. The
maximum number of objects that are returned for this request. If
MaxResults isn't specified with SortBy, the request returns 1000 results
as the default value for this parameter.

For \code{\link[=costexplorer_get_tags]{get_tags}}, MaxResults has an upper quota
of 1000.}

\item{NextPageToken}{The token to retrieve the next set of results. Amazon Web Services
provides the token when the response from a previous call has more
results than the maximum page size.}
}
\description{
Queries for available tag keys and tag values for a specified period. You can search the tag values for an arbitrary string.

See \url{https://www.paws-r-sdk.com/docs/costexplorer_get_tags/} for full documentation.
}
\keyword{internal}
