% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_copy_db_parameter_group}
\alias{rds_copy_db_parameter_group}
\title{Copies the specified DB parameter group}
\usage{
rds_copy_db_parameter_group(
  SourceDBParameterGroupIdentifier,
  TargetDBParameterGroupIdentifier,
  TargetDBParameterGroupDescription,
  Tags = NULL
)
}
\arguments{
\item{SourceDBParameterGroupIdentifier}{[required] The identifier or ARN for the source DB parameter group. For information
about creating an ARN, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing}{Constructing an ARN for Amazon RDS}
in the \emph{Amazon RDS User Guide}.

Constraints:
\itemize{
\item Must specify a valid DB parameter group.
}}

\item{TargetDBParameterGroupIdentifier}{[required] The identifier for the copied DB parameter group.

Constraints:
\itemize{
\item Can't be null, empty, or blank
\item Must contain from 1 to 255 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-db-parameter-group}}

\item{TargetDBParameterGroupDescription}{[required] A description for the copied DB parameter group.}

\item{Tags}{}
}
\description{
Copies the specified DB parameter group.

See \url{https://www.paws-r-sdk.com/docs/rds_copy_db_parameter_group/} for full documentation.
}
\keyword{internal}
