# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include personalize_service.R
NULL

#' Generates batch recommendations based on a list of items or users stored
#' in Amazon S3 and exports the recommendations to an Amazon S3 bucket
#'
#' @description
#' Generates batch recommendations based on a list of items or users stored in Amazon S3 and exports the recommendations to an Amazon S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_batch_inference_job/](https://www.paws-r-sdk.com/docs/personalize_create_batch_inference_job/) for full documentation.
#'
#' @param jobName &#91;required&#93; The name of the batch inference job to create.
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version that will be used
#' to generate the batch inference recommendations.
#' @param filterArn The ARN of the filter to apply to the batch inference job. For more
#' information on using filters, see [Filtering batch
#' recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html).
#' @param numResults The number of recommendations to retrieve.
#' @param jobInput &#91;required&#93; The Amazon S3 path that leads to the input file to base your
#' recommendations on. The input material must be in JSON format.
#' @param jobOutput &#91;required&#93; The path to the Amazon S3 bucket where the job's output will be stored.
#' @param roleArn &#91;required&#93; The ARN of the Amazon Identity and Access Management role that has
#' permissions to read and write to your input and output Amazon S3 buckets
#' respectively.
#' @param batchInferenceJobConfig The configuration details of a batch inference job.
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the batch inference job.
#' @param batchInferenceJobMode The mode of the batch inference job. To generate descriptive themes for
#' groups of similar items, set the job mode to `THEME_GENERATION`. If you
#' don't want to generate themes, use the default `BATCH_INFERENCE`.
#' 
#' When you get batch recommendations with themes, you will incur
#' additional costs. For more information, see [Amazon Personalize
#' pricing](https://aws.amazon.com/personalize/pricing/).
#' @param themeGenerationConfig For theme generation jobs, specify the name of the column in your Items
#' dataset that contains each item's name.
#'
#' @keywords internal
#'
#' @rdname personalize_create_batch_inference_job
personalize_create_batch_inference_job <- function(jobName, solutionVersionArn, filterArn = NULL, numResults = NULL, jobInput, jobOutput, roleArn, batchInferenceJobConfig = NULL, tags = NULL, batchInferenceJobMode = NULL, themeGenerationConfig = NULL) {
  op <- new_operation(
    name = "CreateBatchInferenceJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_batch_inference_job_input(jobName = jobName, solutionVersionArn = solutionVersionArn, filterArn = filterArn, numResults = numResults, jobInput = jobInput, jobOutput = jobOutput, roleArn = roleArn, batchInferenceJobConfig = batchInferenceJobConfig, tags = tags, batchInferenceJobMode = batchInferenceJobMode, themeGenerationConfig = themeGenerationConfig)
  output <- .personalize$create_batch_inference_job_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_batch_inference_job <- personalize_create_batch_inference_job

#' Creates a batch segment job
#'
#' @description
#' Creates a batch segment job. The operation can handle up to 50 million records and the input file must be in JSON format. For more information, see [Getting batch recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_batch_segment_job/](https://www.paws-r-sdk.com/docs/personalize_create_batch_segment_job/) for full documentation.
#'
#' @param jobName &#91;required&#93; The name of the batch segment job to create.
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version you want the
#' batch segment job to use to generate batch segments.
#' @param filterArn The ARN of the filter to apply to the batch segment job. For more
#' information on using filters, see [Filtering batch
#' recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html).
#' @param numResults The number of predicted users generated by the batch segment job for
#' each line of input data. The maximum number of users per segment is 5
#' million.
#' @param jobInput &#91;required&#93; The Amazon S3 path for the input data used to generate the batch segment
#' job.
#' @param jobOutput &#91;required&#93; The Amazon S3 path for the bucket where the job's output will be stored.
#' @param roleArn &#91;required&#93; The ARN of the Amazon Identity and Access Management role that has
#' permissions to read and write to your input and output Amazon S3 buckets
#' respectively.
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the batch segment job.
#'
#' @keywords internal
#'
#' @rdname personalize_create_batch_segment_job
personalize_create_batch_segment_job <- function(jobName, solutionVersionArn, filterArn = NULL, numResults = NULL, jobInput, jobOutput, roleArn, tags = NULL) {
  op <- new_operation(
    name = "CreateBatchSegmentJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_batch_segment_job_input(jobName = jobName, solutionVersionArn = solutionVersionArn, filterArn = filterArn, numResults = numResults, jobInput = jobInput, jobOutput = jobOutput, roleArn = roleArn, tags = tags)
  output <- .personalize$create_batch_segment_job_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_batch_segment_job <- personalize_create_batch_segment_job

#' You incur campaign costs while it is active
#'
#' @description
#' You incur campaign costs while it is active. To avoid unnecessary costs, make sure to delete the campaign when you are finished. For information about campaign costs, see [Amazon Personalize pricing](https://aws.amazon.com/personalize/pricing/).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_campaign/](https://www.paws-r-sdk.com/docs/personalize_create_campaign/) for full documentation.
#'
#' @param name &#91;required&#93; A name for the new campaign. The campaign name must be unique within
#' your account.
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the trained model to deploy with the
#' campaign. To specify the latest solution version of your solution,
#' specify the ARN of your *solution* in `SolutionArn/$LATEST` format. You
#' must use this format if you set `syncWithLatestSolutionVersion` to
#' `True` in the
#' [CampaignConfig](https://docs.aws.amazon.com/personalize/latest/dg/API_CampaignConfig.html).
#' 
#' To deploy a model that isn't the latest solution version of your
#' solution, specify the ARN of the solution version.
#' 
#' For more information about automatic campaign updates, see [Enabling
#' automatic campaign
#' updates](https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update).
#' @param minProvisionedTPS Specifies the requested minimum provisioned transactions
#' (recommendations) per second that Amazon Personalize will support. A
#' high `minProvisionedTPS` will increase your bill. We recommend starting
#' with 1 for `minProvisionedTPS` (the default). Track your usage using
#' Amazon CloudWatch metrics, and increase the `minProvisionedTPS` as
#' necessary.
#' @param campaignConfig The configuration details of a campaign.
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the campaign.
#'
#' @keywords internal
#'
#' @rdname personalize_create_campaign
personalize_create_campaign <- function(name, solutionVersionArn, minProvisionedTPS = NULL, campaignConfig = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateCampaign",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_campaign_input(name = name, solutionVersionArn = solutionVersionArn, minProvisionedTPS = minProvisionedTPS, campaignConfig = campaignConfig, tags = tags)
  output <- .personalize$create_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_campaign <- personalize_create_campaign

#' Creates a batch job that deletes all references to specific users from
#' an Amazon Personalize dataset group in batches
#'
#' @description
#' Creates a batch job that deletes all references to specific users from an Amazon Personalize dataset group in batches. You specify the users to delete in a CSV file of userIds in an Amazon S3 bucket. After a job completes, Amazon Personalize no longer trains on the users’ data and no longer considers the users when generating user segments. For more information about creating a data deletion job, see [Deleting users](https://docs.aws.amazon.com/personalize/latest/dg/delete-records.html).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_data_deletion_job/](https://www.paws-r-sdk.com/docs/personalize_create_data_deletion_job/) for full documentation.
#'
#' @param jobName &#91;required&#93; The name for the data deletion job.
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group that has the
#' datasets you want to delete records from.
#' @param dataSource &#91;required&#93; The Amazon S3 bucket that contains the list of userIds of the users to
#' delete.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that has permissions to
#' read from the Amazon S3 data source.
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the data deletion job.
#'
#' @keywords internal
#'
#' @rdname personalize_create_data_deletion_job
personalize_create_data_deletion_job <- function(jobName, datasetGroupArn, dataSource, roleArn, tags = NULL) {
  op <- new_operation(
    name = "CreateDataDeletionJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_data_deletion_job_input(jobName = jobName, datasetGroupArn = datasetGroupArn, dataSource = dataSource, roleArn = roleArn, tags = tags)
  output <- .personalize$create_data_deletion_job_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_data_deletion_job <- personalize_create_data_deletion_job

#' Creates an empty dataset and adds it to the specified dataset group
#'
#' @description
#' Creates an empty dataset and adds it to the specified dataset group. Use [`create_dataset_import_job`][personalize_create_dataset_import_job] to import your training data to a dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_dataset/](https://www.paws-r-sdk.com/docs/personalize_create_dataset/) for full documentation.
#'
#' @param name &#91;required&#93; The name for the dataset.
#' @param schemaArn &#91;required&#93; The ARN of the schema to associate with the dataset. The schema defines
#' the dataset fields.
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group to add the dataset
#' to.
#' @param datasetType &#91;required&#93; The type of dataset.
#' 
#' One of the following (case insensitive) values:
#' 
#' -   Interactions
#' 
#' -   Items
#' 
#' -   Users
#' 
#' -   Actions
#' 
#' -   Action_Interactions
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the dataset.
#'
#' @keywords internal
#'
#' @rdname personalize_create_dataset
personalize_create_dataset <- function(name, schemaArn, datasetGroupArn, datasetType, tags = NULL) {
  op <- new_operation(
    name = "CreateDataset",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_dataset_input(name = name, schemaArn = schemaArn, datasetGroupArn = datasetGroupArn, datasetType = datasetType, tags = tags)
  output <- .personalize$create_dataset_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_dataset <- personalize_create_dataset

#' Creates a job that exports data from your dataset to an Amazon S3 bucket
#'
#' @description
#' Creates a job that exports data from your dataset to an Amazon S3 bucket. To allow Amazon Personalize to export the training data, you must specify an service-linked IAM role that gives Amazon Personalize `PutObject` permissions for your Amazon S3 bucket. For information, see [Exporting a dataset](https://docs.aws.amazon.com/personalize/latest/dg/export-data.html) in the Amazon Personalize developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_dataset_export_job/](https://www.paws-r-sdk.com/docs/personalize_create_dataset_export_job/) for full documentation.
#'
#' @param jobName &#91;required&#93; The name for the dataset export job.
#' @param datasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset that contains the data to
#' export.
#' @param ingestionMode The data to export, based on how you imported the data. You can choose
#' to export only `BULK` data that you imported using a dataset import job,
#' only `PUT` data that you imported incrementally (using the console,
#' PutEvents, PutUsers and PutItems operations), or `ALL` for both types.
#' The default value is `PUT`.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM service role that has
#' permissions to add data to your output Amazon S3 bucket.
#' @param jobOutput &#91;required&#93; The path to the Amazon S3 bucket where the job's output is stored.
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the dataset export job.
#'
#' @keywords internal
#'
#' @rdname personalize_create_dataset_export_job
personalize_create_dataset_export_job <- function(jobName, datasetArn, ingestionMode = NULL, roleArn, jobOutput, tags = NULL) {
  op <- new_operation(
    name = "CreateDatasetExportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_dataset_export_job_input(jobName = jobName, datasetArn = datasetArn, ingestionMode = ingestionMode, roleArn = roleArn, jobOutput = jobOutput, tags = tags)
  output <- .personalize$create_dataset_export_job_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_dataset_export_job <- personalize_create_dataset_export_job

#' Creates an empty dataset group
#'
#' @description
#' Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources. A dataset group can contain at most three datasets, one for each type of dataset:
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_dataset_group/](https://www.paws-r-sdk.com/docs/personalize_create_dataset_group/) for full documentation.
#'
#' @param name &#91;required&#93; The name for the new dataset group.
#' @param roleArn The ARN of the Identity and Access Management (IAM) role that has
#' permissions to access the Key Management Service (KMS) key. Supplying an
#' IAM role is only valid when also specifying a KMS key.
#' @param kmsKeyArn The Amazon Resource Name (ARN) of a Key Management Service (KMS) key
#' used to encrypt the datasets.
#' @param domain The domain of the dataset group. Specify a domain to create a Domain
#' dataset group. The domain you specify determines the default schemas for
#' datasets and the use cases available for recommenders. If you don't
#' specify a domain, you create a Custom dataset group with solution
#' versions that you deploy with a campaign.
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the dataset group.
#'
#' @keywords internal
#'
#' @rdname personalize_create_dataset_group
personalize_create_dataset_group <- function(name, roleArn = NULL, kmsKeyArn = NULL, domain = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateDatasetGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_dataset_group_input(name = name, roleArn = roleArn, kmsKeyArn = kmsKeyArn, domain = domain, tags = tags)
  output <- .personalize$create_dataset_group_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_dataset_group <- personalize_create_dataset_group

#' Creates a job that imports training data from your data source (an
#' Amazon S3 bucket) to an Amazon Personalize dataset
#'
#' @description
#' Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize to import the training data, you must specify an IAM service role that has permission to read from the data source, as Amazon Personalize makes a copy of your data and processes it internally. For information on granting access to your Amazon S3 bucket, see [Giving Amazon Personalize Access to Amazon S3 Resources](https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_dataset_import_job/](https://www.paws-r-sdk.com/docs/personalize_create_dataset_import_job/) for full documentation.
#'
#' @param jobName &#91;required&#93; The name for the dataset import job.
#' @param datasetArn &#91;required&#93; The ARN of the dataset that receives the imported data.
#' @param dataSource &#91;required&#93; The Amazon S3 bucket that contains the training data to import.
#' @param roleArn &#91;required&#93; The ARN of the IAM role that has permissions to read from the Amazon S3
#' data source.
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the dataset import job.
#' @param importMode Specify how to add the new records to an existing dataset. The default
#' import mode is `FULL`. If you haven't imported bulk records into the
#' dataset previously, you can only specify `FULL`.
#' 
#' -   Specify `FULL` to overwrite all existing bulk data in your dataset.
#'     Data you imported individually is not replaced.
#' 
#' -   Specify `INCREMENTAL` to append the new records to the existing data
#'     in your dataset. Amazon Personalize replaces any record with the
#'     same ID with the new one.
#' @param publishAttributionMetricsToS3 If you created a metric attribution, specify whether to publish metrics
#' for this import job to Amazon S3
#'
#' @keywords internal
#'
#' @rdname personalize_create_dataset_import_job
personalize_create_dataset_import_job <- function(jobName, datasetArn, dataSource, roleArn, tags = NULL, importMode = NULL, publishAttributionMetricsToS3 = NULL) {
  op <- new_operation(
    name = "CreateDatasetImportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_dataset_import_job_input(jobName = jobName, datasetArn = datasetArn, dataSource = dataSource, roleArn = roleArn, tags = tags, importMode = importMode, publishAttributionMetricsToS3 = publishAttributionMetricsToS3)
  output <- .personalize$create_dataset_import_job_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_dataset_import_job <- personalize_create_dataset_import_job

#' Creates an event tracker that you use when adding event data to a
#' specified dataset group using the PutEvents API
#'
#' @description
#' Creates an event tracker that you use when adding event data to a specified dataset group using the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) API.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_event_tracker/](https://www.paws-r-sdk.com/docs/personalize_create_event_tracker/) for full documentation.
#'
#' @param name &#91;required&#93; The name for the event tracker.
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group that receives the
#' event data.
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the event tracker.
#'
#' @keywords internal
#'
#' @rdname personalize_create_event_tracker
personalize_create_event_tracker <- function(name, datasetGroupArn, tags = NULL) {
  op <- new_operation(
    name = "CreateEventTracker",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_event_tracker_input(name = name, datasetGroupArn = datasetGroupArn, tags = tags)
  output <- .personalize$create_event_tracker_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_event_tracker <- personalize_create_event_tracker

#' Creates a recommendation filter
#'
#' @description
#' Creates a recommendation filter. For more information, see [Filtering recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_filter/](https://www.paws-r-sdk.com/docs/personalize_create_filter/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the filter to create.
#' @param datasetGroupArn &#91;required&#93; The ARN of the dataset group that the filter will belong to.
#' @param filterExpression &#91;required&#93; The filter expression defines which items are included or excluded from
#' recommendations. Filter expression must follow specific format rules.
#' For information about filter expression structure and syntax, see
#' [Filter
#' expressions](https://docs.aws.amazon.com/personalize/latest/dg/filter-expressions.html).
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the filter.
#'
#' @keywords internal
#'
#' @rdname personalize_create_filter
personalize_create_filter <- function(name, datasetGroupArn, filterExpression, tags = NULL) {
  op <- new_operation(
    name = "CreateFilter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_filter_input(name = name, datasetGroupArn = datasetGroupArn, filterExpression = filterExpression, tags = tags)
  output <- .personalize$create_filter_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_filter <- personalize_create_filter

#' Creates a metric attribution
#'
#' @description
#' Creates a metric attribution. A metric attribution creates reports on the data that you import into Amazon Personalize. Depending on how you imported the data, you can view reports in Amazon CloudWatch or Amazon S3. For more information, see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_metric_attribution/](https://www.paws-r-sdk.com/docs/personalize_create_metric_attribution/) for full documentation.
#'
#' @param name &#91;required&#93; A name for the metric attribution.
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the destination dataset group for the
#' metric attribution.
#' @param metrics &#91;required&#93; A list of metric attributes for the metric attribution. Each metric
#' attribute specifies an event type to track and a function. Available
#' functions are `SUM()` or `SAMPLECOUNT()`. For SUM() functions, provide
#' the dataset type (either Interactions or Items) and column to sum as a
#' parameter. For example SUM(Items.PRICE).
#' @param metricsOutputConfig &#91;required&#93; The output configuration details for the metric attribution.
#'
#' @keywords internal
#'
#' @rdname personalize_create_metric_attribution
personalize_create_metric_attribution <- function(name, datasetGroupArn, metrics, metricsOutputConfig) {
  op <- new_operation(
    name = "CreateMetricAttribution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_metric_attribution_input(name = name, datasetGroupArn = datasetGroupArn, metrics = metrics, metricsOutputConfig = metricsOutputConfig)
  output <- .personalize$create_metric_attribution_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_metric_attribution <- personalize_create_metric_attribution

#' Creates a recommender with the recipe (a Domain dataset group use case)
#' you specify
#'
#' @description
#' Creates a recommender with the recipe (a Domain dataset group use case) you specify. You create recommenders for a Domain dataset group and specify the recommender's Amazon Resource Name (ARN) when you make a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_recommender/](https://www.paws-r-sdk.com/docs/personalize_create_recommender/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the recommender.
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the destination domain dataset group
#' for the recommender.
#' @param recipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the recipe that the recommender will
#' use. For a recommender, a recipe is a Domain dataset group use case.
#' Only Domain dataset group use cases can be used to create a recommender.
#' For information about use cases see [Choosing recommender use
#' cases](https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html).
#' @param recommenderConfig The configuration details of the recommender.
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the recommender.
#'
#' @keywords internal
#'
#' @rdname personalize_create_recommender
personalize_create_recommender <- function(name, datasetGroupArn, recipeArn, recommenderConfig = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRecommender",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_recommender_input(name = name, datasetGroupArn = datasetGroupArn, recipeArn = recipeArn, recommenderConfig = recommenderConfig, tags = tags)
  output <- .personalize$create_recommender_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_recommender <- personalize_create_recommender

#' Creates an Amazon Personalize schema from the specified schema string
#'
#' @description
#' Creates an Amazon Personalize schema from the specified schema string. The schema you create must be in Avro JSON format.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_schema/](https://www.paws-r-sdk.com/docs/personalize_create_schema/) for full documentation.
#'
#' @param name &#91;required&#93; The name for the schema.
#' @param schema &#91;required&#93; A schema in Avro JSON format.
#' @param domain The domain for the schema. If you are creating a schema for a dataset in
#' a Domain dataset group, specify the domain you chose when you created
#' the Domain dataset group.
#'
#' @keywords internal
#'
#' @rdname personalize_create_schema
personalize_create_schema <- function(name, schema, domain = NULL) {
  op <- new_operation(
    name = "CreateSchema",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_schema_input(name = name, schema = schema, domain = domain)
  output <- .personalize$create_schema_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_schema <- personalize_create_schema

#' By default, all new solutions use automatic training
#'
#' @description
#' By default, all new solutions use automatic training. With automatic training, you incur training costs while your solution is active. To avoid unnecessary costs, when you are finished you can [update the solution](https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateSolution.html) to turn off automatic training. For information about training costs, see [Amazon Personalize pricing](https://aws.amazon.com/personalize/pricing/).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_solution/](https://www.paws-r-sdk.com/docs/personalize_create_solution/) for full documentation.
#'
#' @param name &#91;required&#93; The name for the solution.
#' @param performHPO Whether to perform hyperparameter optimization (HPO) on the specified or
#' selected recipe. The default is `false`.
#' 
#' When performing AutoML, this parameter is always `true` and you should
#' not set it to `false`.
#' @param performAutoML We don't recommend enabling automated machine learning. Instead, match
#' your use case to the available Amazon Personalize recipes. For more
#' information, see [Choosing a
#' recipe](https://docs.aws.amazon.com/personalize/latest/dg/working-with-predefined-recipes.html).
#' 
#' Whether to perform automated machine learning (AutoML). The default is
#' `false`. For this case, you must specify `recipeArn`.
#' 
#' When set to `true`, Amazon Personalize analyzes your training data and
#' selects the optimal USER_PERSONALIZATION recipe and hyperparameters. In
#' this case, you must omit `recipeArn`. Amazon Personalize determines the
#' optimal recipe by running tests with different values for the
#' hyperparameters. AutoML lengthens the training process as compared to
#' selecting a specific recipe.
#' @param performAutoTraining Whether the solution uses automatic training to create new solution
#' versions (trained models). The default is `True` and the solution
#' automatically creates new solution versions every 7 days. You can change
#' the training frequency by specifying a `schedulingExpression` in the
#' `AutoTrainingConfig` as part of solution configuration. For more
#' information about automatic training, see [Configuring automatic
#' training](https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html).
#' 
#' Automatic solution version creation starts within one hour after the
#' solution is ACTIVE. If you manually create a solution version within the
#' hour, the solution skips the first automatic training.
#' 
#' After training starts, you can get the solution version's Amazon
#' Resource Name (ARN) with the
#' [`list_solution_versions`][personalize_list_solution_versions] API
#' operation. To get its status, use the
#' [`describe_solution_version`][personalize_describe_solution_version].
#' @param recipeArn The Amazon Resource Name (ARN) of the recipe to use for model training.
#' This is required when `performAutoML` is false. For information about
#' different Amazon Personalize recipes and their ARNs, see [Choosing a
#' recipe](https://docs.aws.amazon.com/personalize/latest/dg/working-with-predefined-recipes.html).
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group that provides the
#' training data.
#' @param eventType When your have multiple event types (using an `EVENT_TYPE` schema
#' field), this parameter specifies which event type (for example, 'click'
#' or 'like') is used for training the model.
#' 
#' If you do not provide an `eventType`, Amazon Personalize will use all
#' interactions for training with equal weight regardless of type.
#' @param solutionConfig The configuration properties for the solution. When `performAutoML` is
#' set to true, Amazon Personalize only evaluates the `autoMLConfig`
#' section of the solution configuration.
#' 
#' Amazon Personalize doesn't support configuring the `hpoObjective` at
#' this time.
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the solution.
#'
#' @keywords internal
#'
#' @rdname personalize_create_solution
personalize_create_solution <- function(name, performHPO = NULL, performAutoML = NULL, performAutoTraining = NULL, recipeArn = NULL, datasetGroupArn, eventType = NULL, solutionConfig = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateSolution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_solution_input(name = name, performHPO = performHPO, performAutoML = performAutoML, performAutoTraining = performAutoTraining, recipeArn = recipeArn, datasetGroupArn = datasetGroupArn, eventType = eventType, solutionConfig = solutionConfig, tags = tags)
  output <- .personalize$create_solution_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_solution <- personalize_create_solution

#' Trains or retrains an active solution in a Custom dataset group
#'
#' @description
#' Trains or retrains an active solution in a Custom dataset group. A solution is created using the [`create_solution`][personalize_create_solution] operation and must be in the ACTIVE state before calling [`create_solution_version`][personalize_create_solution_version]. A new version of the solution is created every time you call this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_create_solution_version/](https://www.paws-r-sdk.com/docs/personalize_create_solution_version/) for full documentation.
#'
#' @param name The name of the solution version.
#' @param solutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution containing the training
#' configuration information.
#' @param trainingMode The scope of training to be performed when creating the solution
#' version. The default is `FULL`. This creates a completely new model
#' based on the entirety of the training data from the datasets in your
#' dataset group.
#' 
#' If you use
#' [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html),
#' you can specify a training mode of `UPDATE`. This updates the model to
#' consider new items for recommendations. It is not a full retraining. You
#' should still complete a full retraining weekly. If you specify `UPDATE`,
#' Amazon Personalize will stop automatic updates for the solution version.
#' To resume updates, create a new solution with training mode set to
#' `FULL` and deploy it in a campaign. For more information about automatic
#' updates, see [Automatic
#' updates](https://docs.aws.amazon.com/personalize/latest/dg/use-case-recipe-features.html#maintaining-with-automatic-updates).
#' 
#' The `UPDATE` option can only be used when you already have an active
#' solution version created from the input solution using the `FULL` option
#' and the input solution was trained with the
#' [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html)
#' recipe or the legacy
#' [HRNN-Coldstart](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html)
#' recipe.
#' @param tags A list of
#' [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
#' to apply to the solution version.
#'
#' @keywords internal
#'
#' @rdname personalize_create_solution_version
personalize_create_solution_version <- function(name = NULL, solutionArn, trainingMode = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateSolutionVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$create_solution_version_input(name = name, solutionArn = solutionArn, trainingMode = trainingMode, tags = tags)
  output <- .personalize$create_solution_version_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_solution_version <- personalize_create_solution_version

#' Removes a campaign by deleting the solution deployment
#'
#' @description
#' Removes a campaign by deleting the solution deployment. The solution that the campaign is based on is not deleted and can be redeployed when needed. A deleted campaign can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request. For information on creating campaigns, see [`create_campaign`][personalize_create_campaign].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_delete_campaign/](https://www.paws-r-sdk.com/docs/personalize_delete_campaign/) for full documentation.
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign to delete.
#'
#' @keywords internal
#'
#' @rdname personalize_delete_campaign
personalize_delete_campaign <- function(campaignArn) {
  op <- new_operation(
    name = "DeleteCampaign",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$delete_campaign_input(campaignArn = campaignArn)
  output <- .personalize$delete_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_campaign <- personalize_delete_campaign

#' Deletes a dataset
#'
#' @description
#' Deletes a dataset. You can't delete a dataset if an associated `DatasetImportJob` or `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on datasets, see [`create_dataset`][personalize_create_dataset].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_delete_dataset/](https://www.paws-r-sdk.com/docs/personalize_delete_dataset/) for full documentation.
#'
#' @param datasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset to delete.
#'
#' @keywords internal
#'
#' @rdname personalize_delete_dataset
personalize_delete_dataset <- function(datasetArn) {
  op <- new_operation(
    name = "DeleteDataset",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$delete_dataset_input(datasetArn = datasetArn)
  output <- .personalize$delete_dataset_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_dataset <- personalize_delete_dataset

#' Deletes a dataset group
#'
#' @description
#' Deletes a dataset group. Before you delete a dataset group, you must delete the following:
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_delete_dataset_group/](https://www.paws-r-sdk.com/docs/personalize_delete_dataset_group/) for full documentation.
#'
#' @param datasetGroupArn &#91;required&#93; The ARN of the dataset group to delete.
#'
#' @keywords internal
#'
#' @rdname personalize_delete_dataset_group
personalize_delete_dataset_group <- function(datasetGroupArn) {
  op <- new_operation(
    name = "DeleteDatasetGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$delete_dataset_group_input(datasetGroupArn = datasetGroupArn)
  output <- .personalize$delete_dataset_group_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_dataset_group <- personalize_delete_dataset_group

#' Deletes the event tracker
#'
#' @description
#' Deletes the event tracker. Does not delete the dataset from the dataset group. For more information on event trackers, see [`create_event_tracker`][personalize_create_event_tracker].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_delete_event_tracker/](https://www.paws-r-sdk.com/docs/personalize_delete_event_tracker/) for full documentation.
#'
#' @param eventTrackerArn &#91;required&#93; The Amazon Resource Name (ARN) of the event tracker to delete.
#'
#' @keywords internal
#'
#' @rdname personalize_delete_event_tracker
personalize_delete_event_tracker <- function(eventTrackerArn) {
  op <- new_operation(
    name = "DeleteEventTracker",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$delete_event_tracker_input(eventTrackerArn = eventTrackerArn)
  output <- .personalize$delete_event_tracker_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_event_tracker <- personalize_delete_event_tracker

#' Deletes a filter
#'
#' @description
#' Deletes a filter.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_delete_filter/](https://www.paws-r-sdk.com/docs/personalize_delete_filter/) for full documentation.
#'
#' @param filterArn &#91;required&#93; The ARN of the filter to delete.
#'
#' @keywords internal
#'
#' @rdname personalize_delete_filter
personalize_delete_filter <- function(filterArn) {
  op <- new_operation(
    name = "DeleteFilter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$delete_filter_input(filterArn = filterArn)
  output <- .personalize$delete_filter_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_filter <- personalize_delete_filter

#' Deletes a metric attribution
#'
#' @description
#' Deletes a metric attribution.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_delete_metric_attribution/](https://www.paws-r-sdk.com/docs/personalize_delete_metric_attribution/) for full documentation.
#'
#' @param metricAttributionArn &#91;required&#93; The metric attribution's Amazon Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname personalize_delete_metric_attribution
personalize_delete_metric_attribution <- function(metricAttributionArn) {
  op <- new_operation(
    name = "DeleteMetricAttribution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$delete_metric_attribution_input(metricAttributionArn = metricAttributionArn)
  output <- .personalize$delete_metric_attribution_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_metric_attribution <- personalize_delete_metric_attribution

#' Deactivates and removes a recommender
#'
#' @description
#' Deactivates and removes a recommender. A deleted recommender can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_delete_recommender/](https://www.paws-r-sdk.com/docs/personalize_delete_recommender/) for full documentation.
#'
#' @param recommenderArn &#91;required&#93; The Amazon Resource Name (ARN) of the recommender to delete.
#'
#' @keywords internal
#'
#' @rdname personalize_delete_recommender
personalize_delete_recommender <- function(recommenderArn) {
  op <- new_operation(
    name = "DeleteRecommender",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$delete_recommender_input(recommenderArn = recommenderArn)
  output <- .personalize$delete_recommender_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_recommender <- personalize_delete_recommender

#' Deletes a schema
#'
#' @description
#' Deletes a schema. Before deleting a schema, you must delete all datasets referencing the schema. For more information on schemas, see [`create_schema`][personalize_create_schema].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_delete_schema/](https://www.paws-r-sdk.com/docs/personalize_delete_schema/) for full documentation.
#'
#' @param schemaArn &#91;required&#93; The Amazon Resource Name (ARN) of the schema to delete.
#'
#' @keywords internal
#'
#' @rdname personalize_delete_schema
personalize_delete_schema <- function(schemaArn) {
  op <- new_operation(
    name = "DeleteSchema",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$delete_schema_input(schemaArn = schemaArn)
  output <- .personalize$delete_schema_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_schema <- personalize_delete_schema

#' Deletes all versions of a solution and the Solution object itself
#'
#' @description
#' Deletes all versions of a solution and the `Solution` object itself. Before deleting a solution, you must delete all campaigns based on the solution. To determine what campaigns are using the solution, call [`list_campaigns`][personalize_list_campaigns] and supply the Amazon Resource Name (ARN) of the solution. You can't delete a solution if an associated `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on solutions, see [`create_solution`][personalize_create_solution].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_delete_solution/](https://www.paws-r-sdk.com/docs/personalize_delete_solution/) for full documentation.
#'
#' @param solutionArn &#91;required&#93; The ARN of the solution to delete.
#'
#' @keywords internal
#'
#' @rdname personalize_delete_solution
personalize_delete_solution <- function(solutionArn) {
  op <- new_operation(
    name = "DeleteSolution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$delete_solution_input(solutionArn = solutionArn)
  output <- .personalize$delete_solution_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_solution <- personalize_delete_solution

#' Describes the given algorithm
#'
#' @description
#' Describes the given algorithm.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_algorithm/](https://www.paws-r-sdk.com/docs/personalize_describe_algorithm/) for full documentation.
#'
#' @param algorithmArn &#91;required&#93; The Amazon Resource Name (ARN) of the algorithm to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_algorithm
personalize_describe_algorithm <- function(algorithmArn) {
  op <- new_operation(
    name = "DescribeAlgorithm",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_algorithm_input(algorithmArn = algorithmArn)
  output <- .personalize$describe_algorithm_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_algorithm <- personalize_describe_algorithm

#' Gets the properties of a batch inference job including name, Amazon
#' Resource Name (ARN), status, input and output configurations, and the
#' ARN of the solution version used to generate the recommendations
#'
#' @description
#' Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate the recommendations.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_batch_inference_job/](https://www.paws-r-sdk.com/docs/personalize_describe_batch_inference_job/) for full documentation.
#'
#' @param batchInferenceJobArn &#91;required&#93; The ARN of the batch inference job to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_batch_inference_job
personalize_describe_batch_inference_job <- function(batchInferenceJobArn) {
  op <- new_operation(
    name = "DescribeBatchInferenceJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_batch_inference_job_input(batchInferenceJobArn = batchInferenceJobArn)
  output <- .personalize$describe_batch_inference_job_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_batch_inference_job <- personalize_describe_batch_inference_job

#' Gets the properties of a batch segment job including name, Amazon
#' Resource Name (ARN), status, input and output configurations, and the
#' ARN of the solution version used to generate segments
#'
#' @description
#' Gets the properties of a batch segment job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate segments.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_batch_segment_job/](https://www.paws-r-sdk.com/docs/personalize_describe_batch_segment_job/) for full documentation.
#'
#' @param batchSegmentJobArn &#91;required&#93; The ARN of the batch segment job to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_batch_segment_job
personalize_describe_batch_segment_job <- function(batchSegmentJobArn) {
  op <- new_operation(
    name = "DescribeBatchSegmentJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_batch_segment_job_input(batchSegmentJobArn = batchSegmentJobArn)
  output <- .personalize$describe_batch_segment_job_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_batch_segment_job <- personalize_describe_batch_segment_job

#' Describes the given campaign, including its status
#'
#' @description
#' Describes the given campaign, including its status.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_campaign/](https://www.paws-r-sdk.com/docs/personalize_describe_campaign/) for full documentation.
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_campaign
personalize_describe_campaign <- function(campaignArn) {
  op <- new_operation(
    name = "DescribeCampaign",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_campaign_input(campaignArn = campaignArn)
  output <- .personalize$describe_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_campaign <- personalize_describe_campaign

#' Describes the data deletion job created by CreateDataDeletionJob,
#' including the job status
#'
#' @description
#' Describes the data deletion job created by [`create_data_deletion_job`][personalize_create_data_deletion_job], including the job status.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_data_deletion_job/](https://www.paws-r-sdk.com/docs/personalize_describe_data_deletion_job/) for full documentation.
#'
#' @param dataDeletionJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the data deletion job.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_data_deletion_job
personalize_describe_data_deletion_job <- function(dataDeletionJobArn) {
  op <- new_operation(
    name = "DescribeDataDeletionJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_data_deletion_job_input(dataDeletionJobArn = dataDeletionJobArn)
  output <- .personalize$describe_data_deletion_job_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_data_deletion_job <- personalize_describe_data_deletion_job

#' Describes the given dataset
#'
#' @description
#' Describes the given dataset. For more information on datasets, see [`create_dataset`][personalize_create_dataset].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_dataset/](https://www.paws-r-sdk.com/docs/personalize_describe_dataset/) for full documentation.
#'
#' @param datasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_dataset
personalize_describe_dataset <- function(datasetArn) {
  op <- new_operation(
    name = "DescribeDataset",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_dataset_input(datasetArn = datasetArn)
  output <- .personalize$describe_dataset_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_dataset <- personalize_describe_dataset

#' Describes the dataset export job created by CreateDatasetExportJob,
#' including the export job status
#'
#' @description
#' Describes the dataset export job created by [`create_dataset_export_job`][personalize_create_dataset_export_job], including the export job status.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_dataset_export_job/](https://www.paws-r-sdk.com/docs/personalize_describe_dataset_export_job/) for full documentation.
#'
#' @param datasetExportJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset export job to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_dataset_export_job
personalize_describe_dataset_export_job <- function(datasetExportJobArn) {
  op <- new_operation(
    name = "DescribeDatasetExportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_dataset_export_job_input(datasetExportJobArn = datasetExportJobArn)
  output <- .personalize$describe_dataset_export_job_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_dataset_export_job <- personalize_describe_dataset_export_job

#' Describes the given dataset group
#'
#' @description
#' Describes the given dataset group. For more information on dataset groups, see [`create_dataset_group`][personalize_create_dataset_group].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_dataset_group/](https://www.paws-r-sdk.com/docs/personalize_describe_dataset_group/) for full documentation.
#'
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_dataset_group
personalize_describe_dataset_group <- function(datasetGroupArn) {
  op <- new_operation(
    name = "DescribeDatasetGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_dataset_group_input(datasetGroupArn = datasetGroupArn)
  output <- .personalize$describe_dataset_group_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_dataset_group <- personalize_describe_dataset_group

#' Describes the dataset import job created by CreateDatasetImportJob,
#' including the import job status
#'
#' @description
#' Describes the dataset import job created by [`create_dataset_import_job`][personalize_create_dataset_import_job], including the import job status.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_dataset_import_job/](https://www.paws-r-sdk.com/docs/personalize_describe_dataset_import_job/) for full documentation.
#'
#' @param datasetImportJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset import job to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_dataset_import_job
personalize_describe_dataset_import_job <- function(datasetImportJobArn) {
  op <- new_operation(
    name = "DescribeDatasetImportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_dataset_import_job_input(datasetImportJobArn = datasetImportJobArn)
  output <- .personalize$describe_dataset_import_job_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_dataset_import_job <- personalize_describe_dataset_import_job

#' Describes an event tracker
#'
#' @description
#' Describes an event tracker. The response includes the `trackingId` and `status` of the event tracker. For more information on event trackers, see [`create_event_tracker`][personalize_create_event_tracker].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_event_tracker/](https://www.paws-r-sdk.com/docs/personalize_describe_event_tracker/) for full documentation.
#'
#' @param eventTrackerArn &#91;required&#93; The Amazon Resource Name (ARN) of the event tracker to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_event_tracker
personalize_describe_event_tracker <- function(eventTrackerArn) {
  op <- new_operation(
    name = "DescribeEventTracker",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_event_tracker_input(eventTrackerArn = eventTrackerArn)
  output <- .personalize$describe_event_tracker_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_event_tracker <- personalize_describe_event_tracker

#' Describes the given feature transformation
#'
#' @description
#' Describes the given feature transformation.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_feature_transformation/](https://www.paws-r-sdk.com/docs/personalize_describe_feature_transformation/) for full documentation.
#'
#' @param featureTransformationArn &#91;required&#93; The Amazon Resource Name (ARN) of the feature transformation to
#' describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_feature_transformation
personalize_describe_feature_transformation <- function(featureTransformationArn) {
  op <- new_operation(
    name = "DescribeFeatureTransformation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_feature_transformation_input(featureTransformationArn = featureTransformationArn)
  output <- .personalize$describe_feature_transformation_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_feature_transformation <- personalize_describe_feature_transformation

#' Describes a filter's properties
#'
#' @description
#' Describes a filter's properties.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_filter/](https://www.paws-r-sdk.com/docs/personalize_describe_filter/) for full documentation.
#'
#' @param filterArn &#91;required&#93; The ARN of the filter to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_filter
personalize_describe_filter <- function(filterArn) {
  op <- new_operation(
    name = "DescribeFilter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_filter_input(filterArn = filterArn)
  output <- .personalize$describe_filter_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_filter <- personalize_describe_filter

#' Describes a metric attribution
#'
#' @description
#' Describes a metric attribution.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_metric_attribution/](https://www.paws-r-sdk.com/docs/personalize_describe_metric_attribution/) for full documentation.
#'
#' @param metricAttributionArn &#91;required&#93; The metric attribution's Amazon Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname personalize_describe_metric_attribution
personalize_describe_metric_attribution <- function(metricAttributionArn) {
  op <- new_operation(
    name = "DescribeMetricAttribution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_metric_attribution_input(metricAttributionArn = metricAttributionArn)
  output <- .personalize$describe_metric_attribution_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_metric_attribution <- personalize_describe_metric_attribution

#' Describes a recipe
#'
#' @description
#' Describes a recipe.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_recipe/](https://www.paws-r-sdk.com/docs/personalize_describe_recipe/) for full documentation.
#'
#' @param recipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the recipe to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_recipe
personalize_describe_recipe <- function(recipeArn) {
  op <- new_operation(
    name = "DescribeRecipe",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_recipe_input(recipeArn = recipeArn)
  output <- .personalize$describe_recipe_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_recipe <- personalize_describe_recipe

#' Describes the given recommender, including its status
#'
#' @description
#' Describes the given recommender, including its status.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_recommender/](https://www.paws-r-sdk.com/docs/personalize_describe_recommender/) for full documentation.
#'
#' @param recommenderArn &#91;required&#93; The Amazon Resource Name (ARN) of the recommender to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_recommender
personalize_describe_recommender <- function(recommenderArn) {
  op <- new_operation(
    name = "DescribeRecommender",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_recommender_input(recommenderArn = recommenderArn)
  output <- .personalize$describe_recommender_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_recommender <- personalize_describe_recommender

#' Describes a schema
#'
#' @description
#' Describes a schema. For more information on schemas, see [`create_schema`][personalize_create_schema].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_schema/](https://www.paws-r-sdk.com/docs/personalize_describe_schema/) for full documentation.
#'
#' @param schemaArn &#91;required&#93; The Amazon Resource Name (ARN) of the schema to retrieve.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_schema
personalize_describe_schema <- function(schemaArn) {
  op <- new_operation(
    name = "DescribeSchema",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_schema_input(schemaArn = schemaArn)
  output <- .personalize$describe_schema_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_schema <- personalize_describe_schema

#' Describes a solution
#'
#' @description
#' Describes a solution. For more information on solutions, see [`create_solution`][personalize_create_solution].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_solution/](https://www.paws-r-sdk.com/docs/personalize_describe_solution/) for full documentation.
#'
#' @param solutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution to describe.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_solution
personalize_describe_solution <- function(solutionArn) {
  op <- new_operation(
    name = "DescribeSolution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_solution_input(solutionArn = solutionArn)
  output <- .personalize$describe_solution_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_solution <- personalize_describe_solution

#' Describes a specific version of a solution
#'
#' @description
#' Describes a specific version of a solution. For more information on solutions, see [`create_solution`][personalize_create_solution]
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_describe_solution_version/](https://www.paws-r-sdk.com/docs/personalize_describe_solution_version/) for full documentation.
#'
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version.
#'
#' @keywords internal
#'
#' @rdname personalize_describe_solution_version
personalize_describe_solution_version <- function(solutionVersionArn) {
  op <- new_operation(
    name = "DescribeSolutionVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$describe_solution_version_input(solutionVersionArn = solutionVersionArn)
  output <- .personalize$describe_solution_version_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_solution_version <- personalize_describe_solution_version

#' Gets the metrics for the specified solution version
#'
#' @description
#' Gets the metrics for the specified solution version.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_get_solution_metrics/](https://www.paws-r-sdk.com/docs/personalize_get_solution_metrics/) for full documentation.
#'
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version for which to get
#' metrics.
#'
#' @keywords internal
#'
#' @rdname personalize_get_solution_metrics
personalize_get_solution_metrics <- function(solutionVersionArn) {
  op <- new_operation(
    name = "GetSolutionMetrics",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$get_solution_metrics_input(solutionVersionArn = solutionVersionArn)
  output <- .personalize$get_solution_metrics_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$get_solution_metrics <- personalize_get_solution_metrics

#' Gets a list of the batch inference jobs that have been performed off of
#' a solution version
#'
#' @description
#' Gets a list of the batch inference jobs that have been performed off of a solution version.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_batch_inference_jobs/](https://www.paws-r-sdk.com/docs/personalize_list_batch_inference_jobs/) for full documentation.
#'
#' @param solutionVersionArn The Amazon Resource Name (ARN) of the solution version from which the
#' batch inference jobs were created.
#' @param nextToken The token to request the next page of results.
#' @param maxResults The maximum number of batch inference job results to return in each
#' page. The default value is 100.
#'
#' @keywords internal
#'
#' @rdname personalize_list_batch_inference_jobs
personalize_list_batch_inference_jobs <- function(solutionVersionArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListBatchInferenceJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "batchInferenceJobs"),
    stream_api = FALSE
  )
  input <- .personalize$list_batch_inference_jobs_input(solutionVersionArn = solutionVersionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_batch_inference_jobs_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_batch_inference_jobs <- personalize_list_batch_inference_jobs

#' Gets a list of the batch segment jobs that have been performed off of a
#' solution version that you specify
#'
#' @description
#' Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_batch_segment_jobs/](https://www.paws-r-sdk.com/docs/personalize_list_batch_segment_jobs/) for full documentation.
#'
#' @param solutionVersionArn The Amazon Resource Name (ARN) of the solution version that the batch
#' segment jobs used to generate batch segments.
#' @param nextToken The token to request the next page of results.
#' @param maxResults The maximum number of batch segment job results to return in each page.
#' The default value is 100.
#'
#' @keywords internal
#'
#' @rdname personalize_list_batch_segment_jobs
personalize_list_batch_segment_jobs <- function(solutionVersionArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListBatchSegmentJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "batchSegmentJobs"),
    stream_api = FALSE
  )
  input <- .personalize$list_batch_segment_jobs_input(solutionVersionArn = solutionVersionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_batch_segment_jobs_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_batch_segment_jobs <- personalize_list_batch_segment_jobs

#' Returns a list of campaigns that use the given solution
#'
#' @description
#' Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns associated with the account are listed. The response provides the properties for each campaign, including the Amazon Resource Name (ARN). For more information on campaigns, see [`create_campaign`][personalize_create_campaign].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_campaigns/](https://www.paws-r-sdk.com/docs/personalize_list_campaigns/) for full documentation.
#'
#' @param solutionArn The Amazon Resource Name (ARN) of the solution to list the campaigns
#' for. When a solution is not specified, all the campaigns associated with
#' the account are listed.
#' @param nextToken A token returned from the previous call to
#' [`list_campaigns`][personalize_list_campaigns] for getting the next set
#' of campaigns (if they exist).
#' @param maxResults The maximum number of campaigns to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_campaigns
personalize_list_campaigns <- function(solutionArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListCampaigns",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "campaigns"),
    stream_api = FALSE
  )
  input <- .personalize$list_campaigns_input(solutionArn = solutionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_campaigns_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_campaigns <- personalize_list_campaigns

#' Returns a list of data deletion jobs for a dataset group ordered by
#' creation time, with the most recent first
#'
#' @description
#' Returns a list of data deletion jobs for a dataset group ordered by creation time, with the most recent first. When a dataset group is not specified, all the data deletion jobs associated with the account are listed. The response provides the properties for each job, including the Amazon Resource Name (ARN). For more information on data deletion jobs, see [Deleting users](https://docs.aws.amazon.com/personalize/latest/dg/delete-records.html).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_data_deletion_jobs/](https://www.paws-r-sdk.com/docs/personalize_list_data_deletion_jobs/) for full documentation.
#'
#' @param datasetGroupArn The Amazon Resource Name (ARN) of the dataset group to list data
#' deletion jobs for.
#' @param nextToken A token returned from the previous call to
#' [`list_data_deletion_jobs`][personalize_list_data_deletion_jobs] for
#' getting the next set of jobs (if they exist).
#' @param maxResults The maximum number of data deletion jobs to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_data_deletion_jobs
personalize_list_data_deletion_jobs <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDataDeletionJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$list_data_deletion_jobs_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_data_deletion_jobs_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_data_deletion_jobs <- personalize_list_data_deletion_jobs

#' Returns a list of dataset export jobs that use the given dataset
#'
#' @description
#' Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the dataset export jobs associated with the account are listed. The response provides the properties for each dataset export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see [`create_dataset_export_job`][personalize_create_dataset_export_job]. For more information on datasets, see [`create_dataset`][personalize_create_dataset].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_dataset_export_jobs/](https://www.paws-r-sdk.com/docs/personalize_list_dataset_export_jobs/) for full documentation.
#'
#' @param datasetArn The Amazon Resource Name (ARN) of the dataset to list the dataset export
#' jobs for.
#' @param nextToken A token returned from the previous call to
#' [`list_dataset_export_jobs`][personalize_list_dataset_export_jobs] for
#' getting the next set of dataset export jobs (if they exist).
#' @param maxResults The maximum number of dataset export jobs to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_dataset_export_jobs
personalize_list_dataset_export_jobs <- function(datasetArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDatasetExportJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "datasetExportJobs"),
    stream_api = FALSE
  )
  input <- .personalize$list_dataset_export_jobs_input(datasetArn = datasetArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_dataset_export_jobs_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_dataset_export_jobs <- personalize_list_dataset_export_jobs

#' Returns a list of dataset groups
#'
#' @description
#' Returns a list of dataset groups. The response provides the properties for each dataset group, including the Amazon Resource Name (ARN). For more information on dataset groups, see [`create_dataset_group`][personalize_create_dataset_group].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_dataset_groups/](https://www.paws-r-sdk.com/docs/personalize_list_dataset_groups/) for full documentation.
#'
#' @param nextToken A token returned from the previous call to
#' [`list_dataset_groups`][personalize_list_dataset_groups] for getting the
#' next set of dataset groups (if they exist).
#' @param maxResults The maximum number of dataset groups to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_dataset_groups
personalize_list_dataset_groups <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDatasetGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "datasetGroups"),
    stream_api = FALSE
  )
  input <- .personalize$list_dataset_groups_input(nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_dataset_groups_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_dataset_groups <- personalize_list_dataset_groups

#' Returns a list of dataset import jobs that use the given dataset
#'
#' @description
#' Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the dataset import jobs associated with the account are listed. The response provides the properties for each dataset import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see [`create_dataset_import_job`][personalize_create_dataset_import_job]. For more information on datasets, see [`create_dataset`][personalize_create_dataset].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_dataset_import_jobs/](https://www.paws-r-sdk.com/docs/personalize_list_dataset_import_jobs/) for full documentation.
#'
#' @param datasetArn The Amazon Resource Name (ARN) of the dataset to list the dataset import
#' jobs for.
#' @param nextToken A token returned from the previous call to
#' [`list_dataset_import_jobs`][personalize_list_dataset_import_jobs] for
#' getting the next set of dataset import jobs (if they exist).
#' @param maxResults The maximum number of dataset import jobs to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_dataset_import_jobs
personalize_list_dataset_import_jobs <- function(datasetArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDatasetImportJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "datasetImportJobs"),
    stream_api = FALSE
  )
  input <- .personalize$list_dataset_import_jobs_input(datasetArn = datasetArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_dataset_import_jobs_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_dataset_import_jobs <- personalize_list_dataset_import_jobs

#' Returns the list of datasets contained in the given dataset group
#'
#' @description
#' Returns the list of datasets contained in the given dataset group. The response provides the properties for each dataset, including the Amazon Resource Name (ARN). For more information on datasets, see [`create_dataset`][personalize_create_dataset].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_datasets/](https://www.paws-r-sdk.com/docs/personalize_list_datasets/) for full documentation.
#'
#' @param datasetGroupArn The Amazon Resource Name (ARN) of the dataset group that contains the
#' datasets to list.
#' @param nextToken A token returned from the previous call to
#' [`list_datasets`][personalize_list_datasets] for getting the next set of
#' dataset import jobs (if they exist).
#' @param maxResults The maximum number of datasets to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_datasets
personalize_list_datasets <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDatasets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "datasets"),
    stream_api = FALSE
  )
  input <- .personalize$list_datasets_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_datasets_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_datasets <- personalize_list_datasets

#' Returns the list of event trackers associated with the account
#'
#' @description
#' Returns the list of event trackers associated with the account. The response provides the properties for each event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers, see [`create_event_tracker`][personalize_create_event_tracker].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_event_trackers/](https://www.paws-r-sdk.com/docs/personalize_list_event_trackers/) for full documentation.
#'
#' @param datasetGroupArn The ARN of a dataset group used to filter the response.
#' @param nextToken A token returned from the previous call to
#' [`list_event_trackers`][personalize_list_event_trackers] for getting the
#' next set of event trackers (if they exist).
#' @param maxResults The maximum number of event trackers to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_event_trackers
personalize_list_event_trackers <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEventTrackers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "eventTrackers"),
    stream_api = FALSE
  )
  input <- .personalize$list_event_trackers_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_event_trackers_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_event_trackers <- personalize_list_event_trackers

#' Lists all filters that belong to a given dataset group
#'
#' @description
#' Lists all filters that belong to a given dataset group.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_filters/](https://www.paws-r-sdk.com/docs/personalize_list_filters/) for full documentation.
#'
#' @param datasetGroupArn The ARN of the dataset group that contains the filters.
#' @param nextToken A token returned from the previous call to
#' [`list_filters`][personalize_list_filters] for getting the next set of
#' filters (if they exist).
#' @param maxResults The maximum number of filters to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_filters
personalize_list_filters <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListFilters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "Filters"),
    stream_api = FALSE
  )
  input <- .personalize$list_filters_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_filters_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_filters <- personalize_list_filters

#' Lists the metrics for the metric attribution
#'
#' @description
#' Lists the metrics for the metric attribution.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_metric_attribution_metrics/](https://www.paws-r-sdk.com/docs/personalize_list_metric_attribution_metrics/) for full documentation.
#'
#' @param metricAttributionArn The Amazon Resource Name (ARN) of the metric attribution to retrieve
#' attributes for.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param maxResults The maximum number of metrics to return in one page of results.
#'
#' @keywords internal
#'
#' @rdname personalize_list_metric_attribution_metrics
personalize_list_metric_attribution_metrics <- function(metricAttributionArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListMetricAttributionMetrics",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "metrics"),
    stream_api = FALSE
  )
  input <- .personalize$list_metric_attribution_metrics_input(metricAttributionArn = metricAttributionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_metric_attribution_metrics_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_metric_attribution_metrics <- personalize_list_metric_attribution_metrics

#' Lists metric attributions
#'
#' @description
#' Lists metric attributions.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_metric_attributions/](https://www.paws-r-sdk.com/docs/personalize_list_metric_attributions/) for full documentation.
#'
#' @param datasetGroupArn The metric attributions' dataset group Amazon Resource Name (ARN).
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param maxResults The maximum number of metric attributions to return in one page of
#' results.
#'
#' @keywords internal
#'
#' @rdname personalize_list_metric_attributions
personalize_list_metric_attributions <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListMetricAttributions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "metricAttributions"),
    stream_api = FALSE
  )
  input <- .personalize$list_metric_attributions_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_metric_attributions_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_metric_attributions <- personalize_list_metric_attributions

#' Returns a list of available recipes
#'
#' @description
#' Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_recipes/](https://www.paws-r-sdk.com/docs/personalize_list_recipes/) for full documentation.
#'
#' @param recipeProvider The default is `SERVICE`.
#' @param nextToken A token returned from the previous call to
#' [`list_recipes`][personalize_list_recipes] for getting the next set of
#' recipes (if they exist).
#' @param maxResults The maximum number of recipes to return.
#' @param domain Filters returned recipes by domain for a Domain dataset group. Only
#' recipes (Domain dataset group use cases) for this domain are included in
#' the response. If you don't specify a domain, all recipes are returned.
#'
#' @keywords internal
#'
#' @rdname personalize_list_recipes
personalize_list_recipes <- function(recipeProvider = NULL, nextToken = NULL, maxResults = NULL, domain = NULL) {
  op <- new_operation(
    name = "ListRecipes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "recipes"),
    stream_api = FALSE
  )
  input <- .personalize$list_recipes_input(recipeProvider = recipeProvider, nextToken = nextToken, maxResults = maxResults, domain = domain)
  output <- .personalize$list_recipes_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_recipes <- personalize_list_recipes

#' Returns a list of recommenders in a given Domain dataset group
#'
#' @description
#' Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all the recommenders associated with the account are listed. The response provides the properties for each recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see [`create_recommender`][personalize_create_recommender].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_recommenders/](https://www.paws-r-sdk.com/docs/personalize_list_recommenders/) for full documentation.
#'
#' @param datasetGroupArn The Amazon Resource Name (ARN) of the Domain dataset group to list the
#' recommenders for. When a Domain dataset group is not specified, all the
#' recommenders associated with the account are listed.
#' @param nextToken A token returned from the previous call to
#' [`list_recommenders`][personalize_list_recommenders] for getting the
#' next set of recommenders (if they exist).
#' @param maxResults The maximum number of recommenders to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_recommenders
personalize_list_recommenders <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListRecommenders",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "recommenders"),
    stream_api = FALSE
  )
  input <- .personalize$list_recommenders_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_recommenders_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_recommenders <- personalize_list_recommenders

#' Returns the list of schemas associated with the account
#'
#' @description
#' Returns the list of schemas associated with the account. The response provides the properties for each schema, including the Amazon Resource Name (ARN). For more information on schemas, see [`create_schema`][personalize_create_schema].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_schemas/](https://www.paws-r-sdk.com/docs/personalize_list_schemas/) for full documentation.
#'
#' @param nextToken A token returned from the previous call to
#' [`list_schemas`][personalize_list_schemas] for getting the next set of
#' schemas (if they exist).
#' @param maxResults The maximum number of schemas to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_schemas
personalize_list_schemas <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSchemas",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "schemas"),
    stream_api = FALSE
  )
  input <- .personalize$list_schemas_input(nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_schemas_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_schemas <- personalize_list_schemas

#' Returns a list of solution versions for the given solution
#'
#' @description
#' Returns a list of solution versions for the given solution. When a solution is not specified, all the solution versions associated with the account are listed. The response provides the properties for each solution version, including the Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_solution_versions/](https://www.paws-r-sdk.com/docs/personalize_list_solution_versions/) for full documentation.
#'
#' @param solutionArn The Amazon Resource Name (ARN) of the solution.
#' @param nextToken A token returned from the previous call to
#' [`list_solution_versions`][personalize_list_solution_versions] for
#' getting the next set of solution versions (if they exist).
#' @param maxResults The maximum number of solution versions to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_solution_versions
personalize_list_solution_versions <- function(solutionArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSolutionVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "solutionVersions"),
    stream_api = FALSE
  )
  input <- .personalize$list_solution_versions_input(solutionArn = solutionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_solution_versions_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_solution_versions <- personalize_list_solution_versions

#' Returns a list of solutions in a given dataset group
#'
#' @description
#' Returns a list of solutions in a given dataset group. When a dataset group is not specified, all the solutions associated with the account are listed. The response provides the properties for each solution, including the Amazon Resource Name (ARN). For more information on solutions, see [`create_solution`][personalize_create_solution].
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_solutions/](https://www.paws-r-sdk.com/docs/personalize_list_solutions/) for full documentation.
#'
#' @param datasetGroupArn The Amazon Resource Name (ARN) of the dataset group.
#' @param nextToken A token returned from the previous call to
#' [`list_solutions`][personalize_list_solutions] for getting the next set
#' of solutions (if they exist).
#' @param maxResults The maximum number of solutions to return.
#'
#' @keywords internal
#'
#' @rdname personalize_list_solutions
personalize_list_solutions <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSolutions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "solutions"),
    stream_api = FALSE
  )
  input <- .personalize$list_solutions_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_solutions_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_solutions <- personalize_list_solutions

#' Get a list of tags attached to a resource
#'
#' @description
#' Get a list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) attached to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/personalize_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The resource's Amazon Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname personalize_list_tags_for_resource
personalize_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .personalize$list_tags_for_resource_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_tags_for_resource <- personalize_list_tags_for_resource

#' Starts a recommender that is INACTIVE
#'
#' @description
#' Starts a recommender that is INACTIVE. Starting a recommender does not create any new models, but resumes billing and automatic retraining for the recommender.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_start_recommender/](https://www.paws-r-sdk.com/docs/personalize_start_recommender/) for full documentation.
#'
#' @param recommenderArn &#91;required&#93; The Amazon Resource Name (ARN) of the recommender to start.
#'
#' @keywords internal
#'
#' @rdname personalize_start_recommender
personalize_start_recommender <- function(recommenderArn) {
  op <- new_operation(
    name = "StartRecommender",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$start_recommender_input(recommenderArn = recommenderArn)
  output <- .personalize$start_recommender_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$start_recommender <- personalize_start_recommender

#' Stops a recommender that is ACTIVE
#'
#' @description
#' Stops a recommender that is ACTIVE. Stopping a recommender halts billing and automatic retraining for the recommender.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_stop_recommender/](https://www.paws-r-sdk.com/docs/personalize_stop_recommender/) for full documentation.
#'
#' @param recommenderArn &#91;required&#93; The Amazon Resource Name (ARN) of the recommender to stop.
#'
#' @keywords internal
#'
#' @rdname personalize_stop_recommender
personalize_stop_recommender <- function(recommenderArn) {
  op <- new_operation(
    name = "StopRecommender",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$stop_recommender_input(recommenderArn = recommenderArn)
  output <- .personalize$stop_recommender_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$stop_recommender <- personalize_stop_recommender

#' Stops creating a solution version that is in a state of CREATE_PENDING
#' or CREATE IN_PROGRESS
#'
#' @description
#' Stops creating a solution version that is in a state of CREATE_PENDING or CREATE IN_PROGRESS.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_stop_solution_version_creation/](https://www.paws-r-sdk.com/docs/personalize_stop_solution_version_creation/) for full documentation.
#'
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version you want to stop
#' creating.
#'
#' @keywords internal
#'
#' @rdname personalize_stop_solution_version_creation
personalize_stop_solution_version_creation <- function(solutionVersionArn) {
  op <- new_operation(
    name = "StopSolutionVersionCreation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$stop_solution_version_creation_input(solutionVersionArn = solutionVersionArn)
  output <- .personalize$stop_solution_version_creation_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$stop_solution_version_creation <- personalize_stop_solution_version_creation

#' Add a list of tags to a resource
#'
#' @description
#' Add a list of tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_tag_resource/](https://www.paws-r-sdk.com/docs/personalize_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The resource's Amazon Resource Name (ARN).
#' @param tags &#91;required&#93; Tags to apply to the resource. For more information see [Tagging Amazon
#' Personalize
#' resources](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html).
#'
#' @keywords internal
#'
#' @rdname personalize_tag_resource
personalize_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .personalize$tag_resource_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$tag_resource <- personalize_tag_resource

#' Removes the specified tags that are attached to a resource
#'
#' @description
#' Removes the specified tags that are attached to a resource. For more information, see [Removing tags from Amazon Personalize resources](https://docs.aws.amazon.com/personalize/latest/dg/tags-remove.html).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_untag_resource/](https://www.paws-r-sdk.com/docs/personalize_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The resource's Amazon Resource Name (ARN).
#' @param tagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname personalize_untag_resource
personalize_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .personalize$untag_resource_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$untag_resource <- personalize_untag_resource

#' Updates a campaign to deploy a retrained solution version with an
#' existing campaign, change your campaign's minProvisionedTPS, or modify
#' your campaign's configuration
#'
#' @description
#' Updates a campaign to deploy a retrained solution version with an existing campaign, change your campaign's `minProvisionedTPS`, or modify your campaign's configuration. For example, you can set `enableMetadataWithRecommendations` to true for an existing campaign.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_update_campaign/](https://www.paws-r-sdk.com/docs/personalize_update_campaign/) for full documentation.
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign.
#' @param solutionVersionArn The Amazon Resource Name (ARN) of a new model to deploy. To specify the
#' latest solution version of your solution, specify the ARN of your
#' *solution* in `SolutionArn/$LATEST` format. You must use this format if
#' you set `syncWithLatestSolutionVersion` to `True` in the
#' [CampaignConfig](https://docs.aws.amazon.com/personalize/latest/dg/API_CampaignConfig.html).
#' 
#' To deploy a model that isn't the latest solution version of your
#' solution, specify the ARN of the solution version.
#' 
#' For more information about automatic campaign updates, see [Enabling
#' automatic campaign
#' updates](https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update).
#' @param minProvisionedTPS Specifies the requested minimum provisioned transactions
#' (recommendations) per second that Amazon Personalize will support. A
#' high `minProvisionedTPS` will increase your bill. We recommend starting
#' with 1 for `minProvisionedTPS` (the default). Track your usage using
#' Amazon CloudWatch metrics, and increase the `minProvisionedTPS` as
#' necessary.
#' @param campaignConfig The configuration details of a campaign.
#'
#' @keywords internal
#'
#' @rdname personalize_update_campaign
personalize_update_campaign <- function(campaignArn, solutionVersionArn = NULL, minProvisionedTPS = NULL, campaignConfig = NULL) {
  op <- new_operation(
    name = "UpdateCampaign",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$update_campaign_input(campaignArn = campaignArn, solutionVersionArn = solutionVersionArn, minProvisionedTPS = minProvisionedTPS, campaignConfig = campaignConfig)
  output <- .personalize$update_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$update_campaign <- personalize_update_campaign

#' Update a dataset to replace its schema with a new or existing one
#'
#' @description
#' Update a dataset to replace its schema with a new or existing one. For more information, see [Replacing a dataset's schema](https://docs.aws.amazon.com/personalize/latest/dg/updating-dataset-schema.html).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_update_dataset/](https://www.paws-r-sdk.com/docs/personalize_update_dataset/) for full documentation.
#'
#' @param datasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset that you want to update.
#' @param schemaArn &#91;required&#93; The Amazon Resource Name (ARN) of the new schema you want use.
#'
#' @keywords internal
#'
#' @rdname personalize_update_dataset
personalize_update_dataset <- function(datasetArn, schemaArn) {
  op <- new_operation(
    name = "UpdateDataset",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$update_dataset_input(datasetArn = datasetArn, schemaArn = schemaArn)
  output <- .personalize$update_dataset_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$update_dataset <- personalize_update_dataset

#' Updates a metric attribution
#'
#' @description
#' Updates a metric attribution.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_update_metric_attribution/](https://www.paws-r-sdk.com/docs/personalize_update_metric_attribution/) for full documentation.
#'
#' @param addMetrics Add new metric attributes to the metric attribution.
#' @param removeMetrics Remove metric attributes from the metric attribution.
#' @param metricsOutputConfig An output config for the metric attribution.
#' @param metricAttributionArn The Amazon Resource Name (ARN) for the metric attribution to update.
#'
#' @keywords internal
#'
#' @rdname personalize_update_metric_attribution
personalize_update_metric_attribution <- function(addMetrics = NULL, removeMetrics = NULL, metricsOutputConfig = NULL, metricAttributionArn = NULL) {
  op <- new_operation(
    name = "UpdateMetricAttribution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$update_metric_attribution_input(addMetrics = addMetrics, removeMetrics = removeMetrics, metricsOutputConfig = metricsOutputConfig, metricAttributionArn = metricAttributionArn)
  output <- .personalize$update_metric_attribution_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$update_metric_attribution <- personalize_update_metric_attribution

#' Updates the recommender to modify the recommender configuration
#'
#' @description
#' Updates the recommender to modify the recommender configuration. If you update the recommender to modify the columns used in training, Amazon Personalize automatically starts a full retraining of the models backing your recommender. While the update completes, you can still get recommendations from the recommender. The recommender uses the previous configuration until the update completes. To track the status of this update, use the `latestRecommenderUpdate` returned in the [`describe_recommender`][personalize_describe_recommender] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_update_recommender/](https://www.paws-r-sdk.com/docs/personalize_update_recommender/) for full documentation.
#'
#' @param recommenderArn &#91;required&#93; The Amazon Resource Name (ARN) of the recommender to modify.
#' @param recommenderConfig &#91;required&#93; The configuration details of the recommender.
#'
#' @keywords internal
#'
#' @rdname personalize_update_recommender
personalize_update_recommender <- function(recommenderArn, recommenderConfig) {
  op <- new_operation(
    name = "UpdateRecommender",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$update_recommender_input(recommenderArn = recommenderArn, recommenderConfig = recommenderConfig)
  output <- .personalize$update_recommender_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$update_recommender <- personalize_update_recommender

#' Updates an Amazon Personalize solution to use a different automatic
#' training configuration
#'
#' @description
#' Updates an Amazon Personalize solution to use a different automatic training configuration. When you update a solution, you can change whether the solution uses automatic training, and you can change the training frequency. For more information about updating a solution, see [Updating a solution](https://docs.aws.amazon.com/personalize/latest/dg/updating-solution.html).
#'
#' See [https://www.paws-r-sdk.com/docs/personalize_update_solution/](https://www.paws-r-sdk.com/docs/personalize_update_solution/) for full documentation.
#'
#' @param solutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution to update.
#' @param performAutoTraining Whether the solution uses automatic training to create new solution
#' versions (trained models). You can change the training frequency by
#' specifying a `schedulingExpression` in the `AutoTrainingConfig` as part
#' of solution configuration.
#' 
#' If you turn on automatic training, the first automatic training starts
#' within one hour after the solution update completes. If you manually
#' create a solution version within the hour, the solution skips the first
#' automatic training. For more information about automatic training, see
#' [Configuring automatic
#' training](https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html).
#' 
#' After training starts, you can get the solution version's Amazon
#' Resource Name (ARN) with the
#' [`list_solution_versions`][personalize_list_solution_versions] API
#' operation. To get its status, use the
#' [`describe_solution_version`][personalize_describe_solution_version].
#' @param solutionUpdateConfig The new configuration details of the solution.
#'
#' @keywords internal
#'
#' @rdname personalize_update_solution
personalize_update_solution <- function(solutionArn, performAutoTraining = NULL, solutionUpdateConfig = NULL) {
  op <- new_operation(
    name = "UpdateSolution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .personalize$update_solution_input(solutionArn = solutionArn, performAutoTraining = performAutoTraining, solutionUpdateConfig = solutionUpdateConfig)
  output <- .personalize$update_solution_output()
  config <- get_config()
  svc <- .personalize$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$update_solution <- personalize_update_solution
