# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ram_service.R
NULL

#' Accepts an invitation to a resource share from another Amazon Web
#' Services account
#'
#' @description
#' Accepts an invitation to a resource share from another Amazon Web Services account. After you accept the invitation, the resources included in the resource share are available to interact with in the relevant Amazon Web Services Management Consoles and tools.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_accept_resource_share_invitation/](https://www.paws-r-sdk.com/docs/ram_accept_resource_share_invitation/) for full documentation.
#'
#' @param resourceShareInvitationArn &#91;required&#93; The [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the invitation that you want to accept.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#'
#' @keywords internal
#'
#' @rdname ram_accept_resource_share_invitation
ram_accept_resource_share_invitation <- function(resourceShareInvitationArn, clientToken = NULL) {
  op <- new_operation(
    name = "AcceptResourceShareInvitation",
    http_method = "POST",
    http_path = "/acceptresourceshareinvitation",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$accept_resource_share_invitation_input(resourceShareInvitationArn = resourceShareInvitationArn, clientToken = clientToken)
  output <- .ram$accept_resource_share_invitation_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$accept_resource_share_invitation <- ram_accept_resource_share_invitation

#' Adds the specified list of principals and list of resources to a
#' resource share
#'
#' @description
#' Adds the specified list of principals and list of resources to a resource share. Principals that already have access to this resource share immediately receive access to the added resources. Newly added principals immediately receive access to the resources shared in this resource share.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_associate_resource_share/](https://www.paws-r-sdk.com/docs/ram_associate_resource_share/) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share that you want to add principals or resources to.
#' @param resourceArns Specifies a list of [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resources that you want to share. This can be `null` if you want
#' to add only principals.
#' @param principals Specifies a list of principals to whom you want to the resource share.
#' This can be `null` if you want to add only resources.
#' 
#' What the principals can do with the resources in the share is determined
#' by the RAM permissions that you associate with the resource share. See
#' [`associate_resource_share_permission`][ram_associate_resource_share_permission].
#' 
#' You can include the following values:
#' 
#' -   An Amazon Web Services account ID, for example: `123456789012`
#' 
#' -   An [Amazon Resource Name
#'     (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#'     of an organization in Organizations, for example:
#'     `organizations::123456789012:organization/o-exampleorgid`
#' 
#' -   An ARN of an organizational unit (OU) in Organizations, for example:
#'     `organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123`
#' 
#' -   An ARN of an IAM role, for example:
#'     `iam::123456789012:role/rolename`
#' 
#' -   An ARN of an IAM user, for example: `iam::123456789012user/username`
#' 
#' Not all resource types can be shared with IAM roles and users. For more
#' information, see [Sharing with IAM roles and
#' users](https://docs.aws.amazon.com/ram/latest/userguide/#permissions-rbp-supported-resource-types)
#' in the *Resource Access Manager User Guide*.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param sources Specifies from which source accounts the service principal has access to
#' the resources in this resource share.
#'
#' @keywords internal
#'
#' @rdname ram_associate_resource_share
ram_associate_resource_share <- function(resourceShareArn, resourceArns = NULL, principals = NULL, clientToken = NULL, sources = NULL) {
  op <- new_operation(
    name = "AssociateResourceShare",
    http_method = "POST",
    http_path = "/associateresourceshare",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$associate_resource_share_input(resourceShareArn = resourceShareArn, resourceArns = resourceArns, principals = principals, clientToken = clientToken, sources = sources)
  output <- .ram$associate_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$associate_resource_share <- ram_associate_resource_share

#' Adds or replaces the RAM permission for a resource type included in a
#' resource share
#'
#' @description
#' Adds or replaces the RAM permission for a resource type included in a resource share. You can have exactly one permission associated with each resource type in the resource share. You can add a new RAM permission only if there are currently no resources of that resource type currently in the resource share.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_associate_resource_share_permission/](https://www.paws-r-sdk.com/docs/ram_associate_resource_share_permission/) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share to which you want to add or replace permissions.
#' @param permissionArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the RAM permission to associate with the resource share. To find the
#' ARN for a permission, use either the
#' [`list_permissions`][ram_list_permissions] operation or go to the
#' Permissions library page in the RAM console and then choose the name of
#' the permission. The ARN is displayed on the detail page.
#' @param replace Specifies whether the specified permission should replace the existing
#' permission associated with the resource share. Use `true` to replace the
#' current permissions. Use `false` to add the permission to a resource
#' share that currently doesn't have a permission. The default value is
#' `false`.
#' 
#' A resource share can have only one permission per resource type. If a
#' resource share already has a permission for the specified resource type
#' and you don't set `replace` to `true` then the operation returns an
#' error. This helps prevent accidental overwriting of a permission.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param permissionVersion Specifies the version of the RAM permission to associate with the
#' resource share. You can specify *only* the version that is currently set
#' as the default version for the permission. If you also set the `replace`
#' pararameter to `true`, then this operation updates an outdated version
#' of the permission to the current default version.
#' 
#' You don't need to specify this parameter because the default behavior is
#' to use the version that is currently set as the default version for the
#' permission. This parameter is supported for backwards compatibility.
#'
#' @keywords internal
#'
#' @rdname ram_associate_resource_share_permission
ram_associate_resource_share_permission <- function(resourceShareArn, permissionArn, replace = NULL, clientToken = NULL, permissionVersion = NULL) {
  op <- new_operation(
    name = "AssociateResourceSharePermission",
    http_method = "POST",
    http_path = "/associateresourcesharepermission",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$associate_resource_share_permission_input(resourceShareArn = resourceShareArn, permissionArn = permissionArn, replace = replace, clientToken = clientToken, permissionVersion = permissionVersion)
  output <- .ram$associate_resource_share_permission_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$associate_resource_share_permission <- ram_associate_resource_share_permission

#' Creates a customer managed permission for a specified resource type that
#' you can attach to resource shares
#'
#' @description
#' Creates a customer managed permission for a specified resource type that you can attach to resource shares. It is created in the Amazon Web Services Region in which you call the operation.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_create_permission/](https://www.paws-r-sdk.com/docs/ram_create_permission/) for full documentation.
#'
#' @param name &#91;required&#93; Specifies the name of the customer managed permission. The name must be
#' unique within the Amazon Web Services Region.
#' @param resourceType &#91;required&#93; Specifies the name of the resource type that this customer managed
#' permission applies to.
#' 
#' The format is ` <service-code>:<resource-type> ` and is not case
#' sensitive. For example, to specify an Amazon EC2 Subnet, you can use the
#' string `ec2:subnet`. To see the list of valid values for this parameter,
#' query the [`list_resource_types`][ram_list_resource_types] operation.
#' @param policyTemplate &#91;required&#93; A string in JSON format string that contains the following elements of a
#' resource-based policy:
#' 
#' -   **Effect**: must be set to `ALLOW`.
#' 
#' -   **Action**: specifies the actions that are allowed by this customer
#'     managed permission. The list must contain only actions that are
#'     supported by the specified resource type. For a list of all actions
#'     supported by each resource type, see [Actions, resources, and
#'     condition keys for Amazon Web Services
#'     services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html)
#'     in the *Identity and Access Management User Guide*.
#' 
#' -   **Condition**: (optional) specifies conditional parameters that must
#'     evaluate to true when a user attempts an action for that action to
#'     be allowed. For more information about the Condition element, see
#'     [IAM policies: Condition
#'     element](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html)
#'     in the *Identity and Access Management User Guide*.
#' 
#' This template can't include either the `Resource` or `Principal`
#' elements. Those are both filled in by RAM when it instantiates the
#' resource-based policy on each resource shared using this managed
#' permission. The `Resource` comes from the ARN of the specific resource
#' that you are sharing. The `Principal` comes from the list of identities
#' added to the resource share.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param tags Specifies a list of one or more tag key and value pairs to attach to the
#' permission.
#'
#' @keywords internal
#'
#' @rdname ram_create_permission
ram_create_permission <- function(name, resourceType, policyTemplate, clientToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreatePermission",
    http_method = "POST",
    http_path = "/createpermission",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$create_permission_input(name = name, resourceType = resourceType, policyTemplate = policyTemplate, clientToken = clientToken, tags = tags)
  output <- .ram$create_permission_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$create_permission <- ram_create_permission

#' Creates a new version of the specified customer managed permission
#'
#' @description
#' Creates a new version of the specified customer managed permission. The new version is automatically set as the default version of the customer managed permission. New resource shares automatically use the default permission. Existing resource shares continue to use their original permission versions, but you can use [`replace_permission_associations`][ram_replace_permission_associations] to update them.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_create_permission_version/](https://www.paws-r-sdk.com/docs/ram_create_permission_version/) for full documentation.
#'
#' @param permissionArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the customer managed permission you're creating a new version for.
#' @param policyTemplate &#91;required&#93; A string in JSON format string that contains the following elements of a
#' resource-based policy:
#' 
#' -   **Effect**: must be set to `ALLOW`.
#' 
#' -   **Action**: specifies the actions that are allowed by this customer
#'     managed permission. The list must contain only actions that are
#'     supported by the specified resource type. For a list of all actions
#'     supported by each resource type, see [Actions, resources, and
#'     condition keys for Amazon Web Services
#'     services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html)
#'     in the *Identity and Access Management User Guide*.
#' 
#' -   **Condition**: (optional) specifies conditional parameters that must
#'     evaluate to true when a user attempts an action for that action to
#'     be allowed. For more information about the Condition element, see
#'     [IAM policies: Condition
#'     element](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html)
#'     in the *Identity and Access Management User Guide*.
#' 
#' This template can't include either the `Resource` or `Principal`
#' elements. Those are both filled in by RAM when it instantiates the
#' resource-based policy on each resource shared using this managed
#' permission. The `Resource` comes from the ARN of the specific resource
#' that you are sharing. The `Principal` comes from the list of identities
#' added to the resource share.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#'
#' @keywords internal
#'
#' @rdname ram_create_permission_version
ram_create_permission_version <- function(permissionArn, policyTemplate, clientToken = NULL) {
  op <- new_operation(
    name = "CreatePermissionVersion",
    http_method = "POST",
    http_path = "/createpermissionversion",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$create_permission_version_input(permissionArn = permissionArn, policyTemplate = policyTemplate, clientToken = clientToken)
  output <- .ram$create_permission_version_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$create_permission_version <- ram_create_permission_version

#' Creates a resource share
#'
#' @description
#' Creates a resource share. You can provide a list of the [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) for the resources that you want to share, a list of principals you want to share the resources with, and the permissions to grant those principals.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_create_resource_share/](https://www.paws-r-sdk.com/docs/ram_create_resource_share/) for full documentation.
#'
#' @param name &#91;required&#93; Specifies the name of the resource share.
#' @param resourceArns Specifies a list of one or more ARNs of the resources to associate with
#' the resource share.
#' @param principals Specifies a list of one or more principals to associate with the
#' resource share.
#' 
#' You can include the following values:
#' 
#' -   An Amazon Web Services account ID, for example: `123456789012`
#' 
#' -   An [Amazon Resource Name
#'     (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#'     of an organization in Organizations, for example:
#'     `organizations::123456789012:organization/o-exampleorgid`
#' 
#' -   An ARN of an organizational unit (OU) in Organizations, for example:
#'     `organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123`
#' 
#' -   An ARN of an IAM role, for example:
#'     `iam::123456789012:role/rolename`
#' 
#' -   An ARN of an IAM user, for example: `iam::123456789012user/username`
#' 
#' Not all resource types can be shared with IAM roles and users. For more
#' information, see [Sharing with IAM roles and
#' users](https://docs.aws.amazon.com/ram/latest/userguide/#permissions-rbp-supported-resource-types)
#' in the *Resource Access Manager User Guide*.
#' @param tags Specifies one or more tags to attach to the resource share itself. It
#' doesn't attach the tags to the resources associated with the resource
#' share.
#' @param allowExternalPrincipals Specifies whether principals outside your organization in Organizations
#' can be associated with a resource share. A value of `true` lets you
#' share with individual Amazon Web Services accounts that are *not* in
#' your organization. A value of `false` only has meaning if your account
#' is a member of an Amazon Web Services Organization. The default value is
#' `true`.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param permissionArns Specifies the [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the RAM permission to associate with the resource share. If you do
#' not specify an ARN for the permission, RAM automatically attaches the
#' default version of the permission for each resource type. You can
#' associate only one permission with each resource type included in the
#' resource share.
#' @param sources Specifies from which source accounts the service principal has access to
#' the resources in this resource share.
#'
#' @keywords internal
#'
#' @rdname ram_create_resource_share
ram_create_resource_share <- function(name, resourceArns = NULL, principals = NULL, tags = NULL, allowExternalPrincipals = NULL, clientToken = NULL, permissionArns = NULL, sources = NULL) {
  op <- new_operation(
    name = "CreateResourceShare",
    http_method = "POST",
    http_path = "/createresourceshare",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$create_resource_share_input(name = name, resourceArns = resourceArns, principals = principals, tags = tags, allowExternalPrincipals = allowExternalPrincipals, clientToken = clientToken, permissionArns = permissionArns, sources = sources)
  output <- .ram$create_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$create_resource_share <- ram_create_resource_share

#' Deletes the specified customer managed permission in the Amazon Web
#' Services Region in which you call this operation
#'
#' @description
#' Deletes the specified customer managed permission in the Amazon Web Services Region in which you call this operation. You can delete a customer managed permission only if it isn't attached to any resource share. The operation deletes all versions associated with the customer managed permission.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_delete_permission/](https://www.paws-r-sdk.com/docs/ram_delete_permission/) for full documentation.
#'
#' @param permissionArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the customer managed permission that you want to delete.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#'
#' @keywords internal
#'
#' @rdname ram_delete_permission
ram_delete_permission <- function(permissionArn, clientToken = NULL) {
  op <- new_operation(
    name = "DeletePermission",
    http_method = "DELETE",
    http_path = "/deletepermission",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$delete_permission_input(permissionArn = permissionArn, clientToken = clientToken)
  output <- .ram$delete_permission_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$delete_permission <- ram_delete_permission

#' Deletes one version of a customer managed permission
#'
#' @description
#' Deletes one version of a customer managed permission. The version you specify must not be attached to any resource share and must not be the default version for the permission.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_delete_permission_version/](https://www.paws-r-sdk.com/docs/ram_delete_permission_version/) for full documentation.
#'
#' @param permissionArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the permission with the version you want to delete.
#' @param permissionVersion &#91;required&#93; Specifies the version number to delete.
#' 
#' You can't delete the default version for a customer managed permission.
#' 
#' You can't delete a version if it's the only version of the permission.
#' You must either first create another version, or delete the permission
#' completely.
#' 
#' You can't delete a version if it is attached to any resource shares. If
#' the version is the default, you must first use
#' [`set_default_permission_version`][ram_set_default_permission_version]
#' to set a different version as the default for the customer managed
#' permission, and then use
#' [`associate_resource_share_permission`][ram_associate_resource_share_permission]
#' to update your resource shares to use the new default version.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#'
#' @keywords internal
#'
#' @rdname ram_delete_permission_version
ram_delete_permission_version <- function(permissionArn, permissionVersion, clientToken = NULL) {
  op <- new_operation(
    name = "DeletePermissionVersion",
    http_method = "DELETE",
    http_path = "/deletepermissionversion",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$delete_permission_version_input(permissionArn = permissionArn, permissionVersion = permissionVersion, clientToken = clientToken)
  output <- .ram$delete_permission_version_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$delete_permission_version <- ram_delete_permission_version

#' Deletes the specified resource share
#'
#' @description
#' Deletes the specified resource share.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_delete_resource_share/](https://www.paws-r-sdk.com/docs/ram_delete_resource_share/) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share to delete.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#'
#' @keywords internal
#'
#' @rdname ram_delete_resource_share
ram_delete_resource_share <- function(resourceShareArn, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteResourceShare",
    http_method = "DELETE",
    http_path = "/deleteresourceshare",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$delete_resource_share_input(resourceShareArn = resourceShareArn, clientToken = clientToken)
  output <- .ram$delete_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$delete_resource_share <- ram_delete_resource_share

#' Removes the specified principals or resources from participating in the
#' specified resource share
#'
#' @description
#' Removes the specified principals or resources from participating in the specified resource share.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_disassociate_resource_share/](https://www.paws-r-sdk.com/docs/ram_disassociate_resource_share/) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share that you want to remove resources or principals
#' from.
#' @param resourceArns Specifies a list of [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' for one or more resources that you want to remove from the resource
#' share. After the operation runs, these resources are no longer shared
#' with principals associated with the resource share.
#' @param principals Specifies a list of one or more principals that no longer are to have
#' access to the resources in this resource share.
#' 
#' You can include the following values:
#' 
#' -   An Amazon Web Services account ID, for example: `123456789012`
#' 
#' -   An [Amazon Resource Name
#'     (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#'     of an organization in Organizations, for example:
#'     `organizations::123456789012:organization/o-exampleorgid`
#' 
#' -   An ARN of an organizational unit (OU) in Organizations, for example:
#'     `organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123`
#' 
#' -   An ARN of an IAM role, for example:
#'     `iam::123456789012:role/rolename`
#' 
#' -   An ARN of an IAM user, for example: `iam::123456789012user/username`
#' 
#' Not all resource types can be shared with IAM roles and users. For more
#' information, see [Sharing with IAM roles and
#' users](https://docs.aws.amazon.com/ram/latest/userguide/#permissions-rbp-supported-resource-types)
#' in the *Resource Access Manager User Guide*.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param sources Specifies from which source accounts the service principal no longer has
#' access to the resources in this resource share.
#'
#' @keywords internal
#'
#' @rdname ram_disassociate_resource_share
ram_disassociate_resource_share <- function(resourceShareArn, resourceArns = NULL, principals = NULL, clientToken = NULL, sources = NULL) {
  op <- new_operation(
    name = "DisassociateResourceShare",
    http_method = "POST",
    http_path = "/disassociateresourceshare",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$disassociate_resource_share_input(resourceShareArn = resourceShareArn, resourceArns = resourceArns, principals = principals, clientToken = clientToken, sources = sources)
  output <- .ram$disassociate_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$disassociate_resource_share <- ram_disassociate_resource_share

#' Removes a managed permission from a resource share
#'
#' @description
#' Removes a managed permission from a resource share. Permission changes take effect immediately. You can remove a managed permission from a resource share only if there are currently no resources of the relevant resource type currently attached to the resource share.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_disassociate_resource_share_permission/](https://www.paws-r-sdk.com/docs/ram_disassociate_resource_share_permission/) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; The [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share that you want to remove the managed permission
#' from.
#' @param permissionArn &#91;required&#93; The [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the managed permission to disassociate from the resource share.
#' Changes to permissions take effect immediately.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#'
#' @keywords internal
#'
#' @rdname ram_disassociate_resource_share_permission
ram_disassociate_resource_share_permission <- function(resourceShareArn, permissionArn, clientToken = NULL) {
  op <- new_operation(
    name = "DisassociateResourceSharePermission",
    http_method = "POST",
    http_path = "/disassociateresourcesharepermission",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$disassociate_resource_share_permission_input(resourceShareArn = resourceShareArn, permissionArn = permissionArn, clientToken = clientToken)
  output <- .ram$disassociate_resource_share_permission_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$disassociate_resource_share_permission <- ram_disassociate_resource_share_permission

#' Enables resource sharing within your organization in Organizations
#'
#' @description
#' Enables resource sharing within your organization in Organizations. This operation creates a service-linked role called `AWSServiceRoleForResourceAccessManager` that has the IAM managed policy named AWSResourceAccessManagerServiceRolePolicy attached. This role permits RAM to retrieve information about the organization and its structure. This lets you share resources with all of the accounts in the calling account's organization by specifying the organization ID, or all of the accounts in an organizational unit (OU) by specifying the OU ID. Until you enable sharing within the organization, you can specify only individual Amazon Web Services accounts, or for supported resource types, IAM roles and users.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_enable_sharing_with_aws_organization/](https://www.paws-r-sdk.com/docs/ram_enable_sharing_with_aws_organization/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname ram_enable_sharing_with_aws_organization
ram_enable_sharing_with_aws_organization <- function() {
  op <- new_operation(
    name = "EnableSharingWithAwsOrganization",
    http_method = "POST",
    http_path = "/enablesharingwithawsorganization",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$enable_sharing_with_aws_organization_input()
  output <- .ram$enable_sharing_with_aws_organization_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$enable_sharing_with_aws_organization <- ram_enable_sharing_with_aws_organization

#' Retrieves the contents of a managed permission in JSON format
#'
#' @description
#' Retrieves the contents of a managed permission in JSON format.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_get_permission/](https://www.paws-r-sdk.com/docs/ram_get_permission/) for full documentation.
#'
#' @param permissionArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the permission whose contents you want to retrieve. To find the ARN
#' for a permission, use either the
#' [`list_permissions`][ram_list_permissions] operation or go to the
#' Permissions library page in the RAM console and then choose the name of
#' the permission. The ARN is displayed on the detail page.
#' @param permissionVersion Specifies the version number of the RAM permission to retrieve. If you
#' don't specify this parameter, the operation retrieves the default
#' version.
#' 
#' To see the list of available versions, use
#' [`list_permission_versions`][ram_list_permission_versions].
#'
#' @keywords internal
#'
#' @rdname ram_get_permission
ram_get_permission <- function(permissionArn, permissionVersion = NULL) {
  op <- new_operation(
    name = "GetPermission",
    http_method = "POST",
    http_path = "/getpermission",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$get_permission_input(permissionArn = permissionArn, permissionVersion = permissionVersion)
  output <- .ram$get_permission_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_permission <- ram_get_permission

#' Retrieves the resource policies for the specified resources that you own
#' and have shared
#'
#' @description
#' Retrieves the resource policies for the specified resources that you own and have shared.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_get_resource_policies/](https://www.paws-r-sdk.com/docs/ram_get_resource_policies/) for full documentation.
#'
#' @param resourceArns &#91;required&#93; Specifies the [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resources whose policies you want to retrieve.
#' @param principal Specifies the principal.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_policies
ram_get_resource_policies <- function(resourceArns, principal = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetResourcePolicies",
    http_method = "POST",
    http_path = "/getresourcepolicies",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "policies"),
    stream_api = FALSE
  )
  input <- .ram$get_resource_policies_input(resourceArns = resourceArns, principal = principal, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$get_resource_policies_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_policies <- ram_get_resource_policies

#' Retrieves the lists of resources and principals that associated for
#' resource shares that you own
#'
#' @description
#' Retrieves the lists of resources and principals that associated for resource shares that you own.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_get_resource_share_associations/](https://www.paws-r-sdk.com/docs/ram_get_resource_share_associations/) for full documentation.
#'
#' @param associationType &#91;required&#93; Specifies whether you want to retrieve the associations that involve a
#' specified resource or principal.
#' 
#' -   `PRINCIPAL` – list the principals whose associations you want to
#'     see.
#' 
#' -   `RESOURCE` – list the resources whose associations you want to see.
#' @param resourceShareArns Specifies a list of [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share whose associations you want to retrieve.
#' @param resourceArn Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of a resource whose resource shares you want to retrieve.
#' 
#' You cannot specify this parameter if the association type is
#' `PRINCIPAL`.
#' @param principal Specifies the ID of the principal whose resource shares you want to
#' retrieve. This can be an Amazon Web Services account ID, an organization
#' ID, an organizational unit ID, or the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of an individual IAM role or user.
#' 
#' You cannot specify this parameter if the association type is `RESOURCE`.
#' @param associationStatus Specifies that you want to retrieve only associations that have this
#' status.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_share_associations
ram_get_resource_share_associations <- function(associationType, resourceShareArns = NULL, resourceArn = NULL, principal = NULL, associationStatus = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetResourceShareAssociations",
    http_method = "POST",
    http_path = "/getresourceshareassociations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "resourceShareAssociations"),
    stream_api = FALSE
  )
  input <- .ram$get_resource_share_associations_input(associationType = associationType, resourceShareArns = resourceShareArns, resourceArn = resourceArn, principal = principal, associationStatus = associationStatus, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$get_resource_share_associations_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_share_associations <- ram_get_resource_share_associations

#' Retrieves details about invitations that you have received for resource
#' shares
#'
#' @description
#' Retrieves details about invitations that you have received for resource shares.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_get_resource_share_invitations/](https://www.paws-r-sdk.com/docs/ram_get_resource_share_invitations/) for full documentation.
#'
#' @param resourceShareInvitationArns Specifies the [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share invitations you want information about.
#' @param resourceShareArns Specifies that you want details about invitations only for the resource
#' shares described by this list of [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_share_invitations
ram_get_resource_share_invitations <- function(resourceShareInvitationArns = NULL, resourceShareArns = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetResourceShareInvitations",
    http_method = "POST",
    http_path = "/getresourceshareinvitations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "resourceShareInvitations"),
    stream_api = FALSE
  )
  input <- .ram$get_resource_share_invitations_input(resourceShareInvitationArns = resourceShareInvitationArns, resourceShareArns = resourceShareArns, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$get_resource_share_invitations_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_share_invitations <- ram_get_resource_share_invitations

#' Retrieves details about the resource shares that you own or that are
#' shared with you
#'
#' @description
#' Retrieves details about the resource shares that you own or that are shared with you.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_get_resource_shares/](https://www.paws-r-sdk.com/docs/ram_get_resource_shares/) for full documentation.
#'
#' @param resourceShareArns Specifies the [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of individual resource shares that you want information about.
#' @param resourceShareStatus Specifies that you want to retrieve details of only those resource
#' shares that have this status.
#' @param resourceOwner &#91;required&#93; Specifies that you want to retrieve details of only those resource
#' shares that match the following:
#' 
#' -   **`SELF`** – resource shares that your account shares with other
#'     accounts
#' 
#' -   **`OTHER-ACCOUNTS`** – resource shares that other accounts share
#'     with your account
#' @param name Specifies the name of an individual resource share that you want to
#' retrieve details about.
#' @param tagFilters Specifies that you want to retrieve details of only those resource
#' shares that match the specified tag keys and values.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#' @param permissionArn Specifies that you want to retrieve details of only those resource
#' shares that use the managed permission with this [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#' @param permissionVersion Specifies that you want to retrieve details for only those resource
#' shares that use the specified version of the managed permission.
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_shares
ram_get_resource_shares <- function(resourceShareArns = NULL, resourceShareStatus = NULL, resourceOwner, name = NULL, tagFilters = NULL, nextToken = NULL, maxResults = NULL, permissionArn = NULL, permissionVersion = NULL) {
  op <- new_operation(
    name = "GetResourceShares",
    http_method = "POST",
    http_path = "/getresourceshares",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "resourceShares"),
    stream_api = FALSE
  )
  input <- .ram$get_resource_shares_input(resourceShareArns = resourceShareArns, resourceShareStatus = resourceShareStatus, resourceOwner = resourceOwner, name = name, tagFilters = tagFilters, nextToken = nextToken, maxResults = maxResults, permissionArn = permissionArn, permissionVersion = permissionVersion)
  output <- .ram$get_resource_shares_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_shares <- ram_get_resource_shares

#' Lists the resources in a resource share that is shared with you but for
#' which the invitation is still PENDING
#'
#' @description
#' Lists the resources in a resource share that is shared with you but for which the invitation is still `PENDING`. That means that you haven't accepted or rejected the invitation and the invitation hasn't expired.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_list_pending_invitation_resources/](https://www.paws-r-sdk.com/docs/ram_list_pending_invitation_resources/) for full documentation.
#'
#' @param resourceShareInvitationArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the invitation. You can use
#' [`get_resource_share_invitations`][ram_get_resource_share_invitations]
#' to find the ARN of the invitation.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#' @param resourceRegionScope Specifies that you want the results to include only resources that have
#' the specified scope.
#' 
#' -   `ALL` – the results include both global and regional resources or
#'     resource types.
#' 
#' -   `GLOBAL` – the results include only global resources or resource
#'     types.
#' 
#' -   `REGIONAL` – the results include only regional resources or resource
#'     types.
#' 
#' The default value is `ALL`.
#'
#' @keywords internal
#'
#' @rdname ram_list_pending_invitation_resources
ram_list_pending_invitation_resources <- function(resourceShareInvitationArn, nextToken = NULL, maxResults = NULL, resourceRegionScope = NULL) {
  op <- new_operation(
    name = "ListPendingInvitationResources",
    http_method = "POST",
    http_path = "/listpendinginvitationresources",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ram$list_pending_invitation_resources_input(resourceShareInvitationArn = resourceShareInvitationArn, nextToken = nextToken, maxResults = maxResults, resourceRegionScope = resourceRegionScope)
  output <- .ram$list_pending_invitation_resources_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_pending_invitation_resources <- ram_list_pending_invitation_resources

#' Lists information about the managed permission and its associations to
#' any resource shares that use this managed permission
#'
#' @description
#' Lists information about the managed permission and its associations to any resource shares that use this managed permission. This lets you see which resource shares use which versions of the specified managed permission.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_list_permission_associations/](https://www.paws-r-sdk.com/docs/ram_list_permission_associations/) for full documentation.
#'
#' @param permissionArn Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the managed permission.
#' @param permissionVersion Specifies that you want to list only those associations with resource
#' shares that use this version of the managed permission. If you don't
#' provide a value for this parameter, then the operation returns
#' information about associations with resource shares that use any version
#' of the managed permission.
#' @param associationStatus Specifies that you want to list only those associations with resource
#' shares that match this status.
#' @param resourceType Specifies that you want to list only those associations with resource
#' shares that include at least one resource of this resource type.
#' @param featureSet Specifies that you want to list only those associations with resource
#' shares that have a `featureSet` with this value.
#' @param defaultVersion When `true`, specifies that you want to list only those associations
#' with resource shares that use the default version of the specified
#' managed permission.
#' 
#' When `false` (the default value), lists associations with resource
#' shares that use any version of the specified managed permission.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_list_permission_associations
ram_list_permission_associations <- function(permissionArn = NULL, permissionVersion = NULL, associationStatus = NULL, resourceType = NULL, featureSet = NULL, defaultVersion = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPermissionAssociations",
    http_method = "POST",
    http_path = "/listpermissionassociations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ram$list_permission_associations_input(permissionArn = permissionArn, permissionVersion = permissionVersion, associationStatus = associationStatus, resourceType = resourceType, featureSet = featureSet, defaultVersion = defaultVersion, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$list_permission_associations_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_permission_associations <- ram_list_permission_associations

#' Lists the available versions of the specified RAM permission
#'
#' @description
#' Lists the available versions of the specified RAM permission.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_list_permission_versions/](https://www.paws-r-sdk.com/docs/ram_list_permission_versions/) for full documentation.
#'
#' @param permissionArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the RAM permission whose versions you want to list. You can use the
#' `permissionVersion` parameter on the
#' [`associate_resource_share_permission`][ram_associate_resource_share_permission]
#' operation to specify a non-default version to attach.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_list_permission_versions
ram_list_permission_versions <- function(permissionArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPermissionVersions",
    http_method = "POST",
    http_path = "/listpermissionversions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ram$list_permission_versions_input(permissionArn = permissionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$list_permission_versions_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_permission_versions <- ram_list_permission_versions

#' Retrieves a list of available RAM permissions that you can use for the
#' supported resource types
#'
#' @description
#' Retrieves a list of available RAM permissions that you can use for the supported resource types.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_list_permissions/](https://www.paws-r-sdk.com/docs/ram_list_permissions/) for full documentation.
#'
#' @param resourceType Specifies that you want to list only those permissions that apply to the
#' specified resource type. This parameter is not case sensitive.
#' 
#' For example, to list only permissions that apply to Amazon EC2 subnets,
#' specify `ec2:subnet`. You can use the
#' [`list_resource_types`][ram_list_resource_types] operation to get the
#' specific string required.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#' @param permissionType Specifies that you want to list only permissions of this type:
#' 
#' -   `AWS` – returns only Amazon Web Services managed permissions.
#' 
#' -   `LOCAL` – returns only customer managed permissions
#' 
#' -   `ALL` – returns both Amazon Web Services managed permissions and
#'     customer managed permissions.
#' 
#' If you don't specify this parameter, the default is `All`.
#'
#' @keywords internal
#'
#' @rdname ram_list_permissions
ram_list_permissions <- function(resourceType = NULL, nextToken = NULL, maxResults = NULL, permissionType = NULL) {
  op <- new_operation(
    name = "ListPermissions",
    http_method = "POST",
    http_path = "/listpermissions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ram$list_permissions_input(resourceType = resourceType, nextToken = nextToken, maxResults = maxResults, permissionType = permissionType)
  output <- .ram$list_permissions_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_permissions <- ram_list_permissions

#' Lists the principals that you are sharing resources with or that are
#' sharing resources with you
#'
#' @description
#' Lists the principals that you are sharing resources with or that are sharing resources with you.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_list_principals/](https://www.paws-r-sdk.com/docs/ram_list_principals/) for full documentation.
#'
#' @param resourceOwner &#91;required&#93; Specifies that you want to list information for only resource shares
#' that match the following:
#' 
#' -   **`SELF`** – principals that your account is sharing resources with
#' 
#' -   **`OTHER-ACCOUNTS`** – principals that are sharing resources with
#'     your account
#' @param resourceArn Specifies that you want to list principal information for the resource
#' share with the specified [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#' @param principals Specifies that you want to list information for only the listed
#' principals.
#' 
#' You can include the following values:
#' 
#' -   An Amazon Web Services account ID, for example: `123456789012`
#' 
#' -   An [Amazon Resource Name
#'     (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#'     of an organization in Organizations, for example:
#'     `organizations::123456789012:organization/o-exampleorgid`
#' 
#' -   An ARN of an organizational unit (OU) in Organizations, for example:
#'     `organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123`
#' 
#' -   An ARN of an IAM role, for example:
#'     `iam::123456789012:role/rolename`
#' 
#' -   An ARN of an IAM user, for example: `iam::123456789012user/username`
#' 
#' Not all resource types can be shared with IAM roles and users. For more
#' information, see [Sharing with IAM roles and
#' users](https://docs.aws.amazon.com/ram/latest/userguide/#permissions-rbp-supported-resource-types)
#' in the *Resource Access Manager User Guide*.
#' @param resourceType Specifies that you want to list information for only principals
#' associated with resource shares that include the specified resource
#' type.
#' 
#' For a list of valid values, query the
#' [`list_resource_types`][ram_list_resource_types] operation.
#' @param resourceShareArns Specifies that you want to list information for only principals
#' associated with the resource shares specified by a list the [Amazon
#' Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_list_principals
ram_list_principals <- function(resourceOwner, resourceArn = NULL, principals = NULL, resourceType = NULL, resourceShareArns = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPrincipals",
    http_method = "POST",
    http_path = "/listprincipals",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "principals"),
    stream_api = FALSE
  )
  input <- .ram$list_principals_input(resourceOwner = resourceOwner, resourceArn = resourceArn, principals = principals, resourceType = resourceType, resourceShareArns = resourceShareArns, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$list_principals_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_principals <- ram_list_principals

#' Retrieves the current status of the asynchronous tasks performed by RAM
#' when you perform the ReplacePermissionAssociationsWork operation
#'
#' @description
#' Retrieves the current status of the asynchronous tasks performed by RAM when you perform the ReplacePermissionAssociationsWork operation.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_list_replace_permission_associations_work/](https://www.paws-r-sdk.com/docs/ram_list_replace_permission_associations_work/) for full documentation.
#'
#' @param workIds A list of IDs. These values come from the `id`field of the
#' `replacePermissionAssociationsWork`structure returned by the
#' [`replace_permission_associations`][ram_replace_permission_associations]
#' operation.
#' @param status Specifies that you want to see only the details about requests with a
#' status that matches this value.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_list_replace_permission_associations_work
ram_list_replace_permission_associations_work <- function(workIds = NULL, status = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListReplacePermissionAssociationsWork",
    http_method = "POST",
    http_path = "/listreplacepermissionassociationswork",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ram$list_replace_permission_associations_work_input(workIds = workIds, status = status, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$list_replace_permission_associations_work_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_replace_permission_associations_work <- ram_list_replace_permission_associations_work

#' Lists the RAM permissions that are associated with a resource share
#'
#' @description
#' Lists the RAM permissions that are associated with a resource share.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_list_resource_share_permissions/](https://www.paws-r-sdk.com/docs/ram_list_resource_share_permissions/) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share for which you want to retrieve the associated
#' permissions.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_list_resource_share_permissions
ram_list_resource_share_permissions <- function(resourceShareArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListResourceSharePermissions",
    http_method = "POST",
    http_path = "/listresourcesharepermissions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ram$list_resource_share_permissions_input(resourceShareArn = resourceShareArn, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$list_resource_share_permissions_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_resource_share_permissions <- ram_list_resource_share_permissions

#' Lists the resource types that can be shared by RAM
#'
#' @description
#' Lists the resource types that can be shared by RAM.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_list_resource_types/](https://www.paws-r-sdk.com/docs/ram_list_resource_types/) for full documentation.
#'
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#' @param resourceRegionScope Specifies that you want the results to include only resources that have
#' the specified scope.
#' 
#' -   `ALL` – the results include both global and regional resources or
#'     resource types.
#' 
#' -   `GLOBAL` – the results include only global resources or resource
#'     types.
#' 
#' -   `REGIONAL` – the results include only regional resources or resource
#'     types.
#' 
#' The default value is `ALL`.
#'
#' @keywords internal
#'
#' @rdname ram_list_resource_types
ram_list_resource_types <- function(nextToken = NULL, maxResults = NULL, resourceRegionScope = NULL) {
  op <- new_operation(
    name = "ListResourceTypes",
    http_method = "POST",
    http_path = "/listresourcetypes",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ram$list_resource_types_input(nextToken = nextToken, maxResults = maxResults, resourceRegionScope = resourceRegionScope)
  output <- .ram$list_resource_types_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_resource_types <- ram_list_resource_types

#' Lists the resources that you added to a resource share or the resources
#' that are shared with you
#'
#' @description
#' Lists the resources that you added to a resource share or the resources that are shared with you.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_list_resources/](https://www.paws-r-sdk.com/docs/ram_list_resources/) for full documentation.
#'
#' @param resourceOwner &#91;required&#93; Specifies that you want to list only the resource shares that match the
#' following:
#' 
#' -   **`SELF`** – resources that your account shares with other accounts
#' 
#' -   **`OTHER-ACCOUNTS`** – resources that other accounts share with your
#'     account
#' @param principal Specifies that you want to list only the resource shares that are
#' associated with the specified principal.
#' @param resourceType Specifies that you want to list only the resource shares that include
#' resources of the specified resource type.
#' 
#' For valid values, query the
#' [`list_resource_types`][ram_list_resource_types] operation.
#' @param resourceArns Specifies that you want to list only the resource shares that include
#' resources with the specified [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#' @param resourceShareArns Specifies that you want to list only resources in the resource shares
#' identified by the specified [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#' @param resourceRegionScope Specifies that you want the results to include only resources that have
#' the specified scope.
#' 
#' -   `ALL` – the results include both global and regional resources or
#'     resource types.
#' 
#' -   `GLOBAL` – the results include only global resources or resource
#'     types.
#' 
#' -   `REGIONAL` – the results include only regional resources or resource
#'     types.
#' 
#' The default value is `ALL`.
#'
#' @keywords internal
#'
#' @rdname ram_list_resources
ram_list_resources <- function(resourceOwner, principal = NULL, resourceType = NULL, resourceArns = NULL, resourceShareArns = NULL, nextToken = NULL, maxResults = NULL, resourceRegionScope = NULL) {
  op <- new_operation(
    name = "ListResources",
    http_method = "POST",
    http_path = "/listresources",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "resources"),
    stream_api = FALSE
  )
  input <- .ram$list_resources_input(resourceOwner = resourceOwner, principal = principal, resourceType = resourceType, resourceArns = resourceArns, resourceShareArns = resourceShareArns, nextToken = nextToken, maxResults = maxResults, resourceRegionScope = resourceRegionScope)
  output <- .ram$list_resources_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_resources <- ram_list_resources

#' When you attach a resource-based policy to a resource, RAM automatically
#' creates a resource share of featureSet=CREATED_FROM_POLICY with a
#' managed permission that has the same IAM permissions as the original
#' resource-based policy
#'
#' @description
#' When you attach a resource-based policy to a resource, RAM automatically creates a resource share of `featureSet`=`CREATED_FROM_POLICY` with a managed permission that has the same IAM permissions as the original resource-based policy. However, this type of managed permission is visible to only the resource share owner, and the associated resource share can't be modified by using RAM.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_promote_permission_created_from_policy/](https://www.paws-r-sdk.com/docs/ram_promote_permission_created_from_policy/) for full documentation.
#'
#' @param permissionArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the `CREATED_FROM_POLICY` permission that you want to promote. You
#' can get this [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' by calling the
#' [`list_resource_share_permissions`][ram_list_resource_share_permissions]
#' operation.
#' @param name &#91;required&#93; Specifies a name for the promoted customer managed permission.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#'
#' @keywords internal
#'
#' @rdname ram_promote_permission_created_from_policy
ram_promote_permission_created_from_policy <- function(permissionArn, name, clientToken = NULL) {
  op <- new_operation(
    name = "PromotePermissionCreatedFromPolicy",
    http_method = "POST",
    http_path = "/promotepermissioncreatedfrompolicy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$promote_permission_created_from_policy_input(permissionArn = permissionArn, name = name, clientToken = clientToken)
  output <- .ram$promote_permission_created_from_policy_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$promote_permission_created_from_policy <- ram_promote_permission_created_from_policy

#' When you attach a resource-based policy to a resource, RAM automatically
#' creates a resource share of featureSet=CREATED_FROM_POLICY with a
#' managed permission that has the same IAM permissions as the original
#' resource-based policy
#'
#' @description
#' When you attach a resource-based policy to a resource, RAM automatically creates a resource share of `featureSet`=`CREATED_FROM_POLICY` with a managed permission that has the same IAM permissions as the original resource-based policy. However, this type of managed permission is visible to only the resource share owner, and the associated resource share can't be modified by using RAM.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_promote_resource_share_created_from_policy/](https://www.paws-r-sdk.com/docs/ram_promote_resource_share_created_from_policy/) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share to promote.
#'
#' @keywords internal
#'
#' @rdname ram_promote_resource_share_created_from_policy
ram_promote_resource_share_created_from_policy <- function(resourceShareArn) {
  op <- new_operation(
    name = "PromoteResourceShareCreatedFromPolicy",
    http_method = "POST",
    http_path = "/promoteresourcesharecreatedfrompolicy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$promote_resource_share_created_from_policy_input(resourceShareArn = resourceShareArn)
  output <- .ram$promote_resource_share_created_from_policy_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$promote_resource_share_created_from_policy <- ram_promote_resource_share_created_from_policy

#' Rejects an invitation to a resource share from another Amazon Web
#' Services account
#'
#' @description
#' Rejects an invitation to a resource share from another Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_reject_resource_share_invitation/](https://www.paws-r-sdk.com/docs/ram_reject_resource_share_invitation/) for full documentation.
#'
#' @param resourceShareInvitationArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the invitation that you want to reject.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#'
#' @keywords internal
#'
#' @rdname ram_reject_resource_share_invitation
ram_reject_resource_share_invitation <- function(resourceShareInvitationArn, clientToken = NULL) {
  op <- new_operation(
    name = "RejectResourceShareInvitation",
    http_method = "POST",
    http_path = "/rejectresourceshareinvitation",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$reject_resource_share_invitation_input(resourceShareInvitationArn = resourceShareInvitationArn, clientToken = clientToken)
  output <- .ram$reject_resource_share_invitation_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$reject_resource_share_invitation <- ram_reject_resource_share_invitation

#' Updates all resource shares that use a managed permission to a different
#' managed permission
#'
#' @description
#' Updates all resource shares that use a managed permission to a different managed permission. This operation always applies the default version of the target managed permission. You can optionally specify that the update applies to only resource shares that currently use a specified version. This enables you to update to the latest version, without changing the which managed permission is used.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_replace_permission_associations/](https://www.paws-r-sdk.com/docs/ram_replace_permission_associations/) for full documentation.
#'
#' @param fromPermissionArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the managed permission that you want to replace.
#' @param fromPermissionVersion Specifies that you want to updated the permissions for only those
#' resource shares that use the specified version of the managed
#' permission.
#' @param toPermissionArn &#91;required&#93; Specifies the ARN of the managed permission that you want to associate
#' with resource shares in place of the one specified by `fromPerssionArn`
#' and `fromPermissionVersion`.
#' 
#' The operation always associates the version that is currently the
#' default for the specified managed permission.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#'
#' @keywords internal
#'
#' @rdname ram_replace_permission_associations
ram_replace_permission_associations <- function(fromPermissionArn, fromPermissionVersion = NULL, toPermissionArn, clientToken = NULL) {
  op <- new_operation(
    name = "ReplacePermissionAssociations",
    http_method = "POST",
    http_path = "/replacepermissionassociations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$replace_permission_associations_input(fromPermissionArn = fromPermissionArn, fromPermissionVersion = fromPermissionVersion, toPermissionArn = toPermissionArn, clientToken = clientToken)
  output <- .ram$replace_permission_associations_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$replace_permission_associations <- ram_replace_permission_associations

#' Designates the specified version number as the default version for the
#' specified customer managed permission
#'
#' @description
#' Designates the specified version number as the default version for the specified customer managed permission. New resource shares automatically use this new default permission. Existing resource shares continue to use their original permission version, but you can use [`replace_permission_associations`][ram_replace_permission_associations] to update them.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_set_default_permission_version/](https://www.paws-r-sdk.com/docs/ram_set_default_permission_version/) for full documentation.
#'
#' @param permissionArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the customer managed permission whose default version you want to
#' change.
#' @param permissionVersion &#91;required&#93; Specifies the version number that you want to designate as the default
#' for customer managed permission. To see a list of all available version
#' numbers, use [`list_permission_versions`][ram_list_permission_versions].
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#'
#' @keywords internal
#'
#' @rdname ram_set_default_permission_version
ram_set_default_permission_version <- function(permissionArn, permissionVersion, clientToken = NULL) {
  op <- new_operation(
    name = "SetDefaultPermissionVersion",
    http_method = "POST",
    http_path = "/setdefaultpermissionversion",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$set_default_permission_version_input(permissionArn = permissionArn, permissionVersion = permissionVersion, clientToken = clientToken)
  output <- .ram$set_default_permission_version_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$set_default_permission_version <- ram_set_default_permission_version

#' Adds the specified tag keys and values to a resource share or managed
#' permission
#'
#' @description
#' Adds the specified tag keys and values to a resource share or managed permission. If you choose a resource share, the tags are attached to only the resource share, not to the resources that are in the resource share.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_tag_resource/](https://www.paws-r-sdk.com/docs/ram_tag_resource/) for full documentation.
#'
#' @param resourceShareArn Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share that you want to add tags to. You must specify
#' *either* `resourceShareArn`, or `resourceArn`, but not both.
#' @param tags &#91;required&#93; A list of one or more tag key and value pairs. The tag key must be
#' present and not be an empty string. The tag value must be present but
#' can be an empty string.
#' @param resourceArn Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the managed permission that you want to add tags to. You must specify
#' *either* `resourceArn`, or `resourceShareArn`, but not both.
#'
#' @keywords internal
#'
#' @rdname ram_tag_resource
ram_tag_resource <- function(resourceShareArn = NULL, tags, resourceArn = NULL) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tagresource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$tag_resource_input(resourceShareArn = resourceShareArn, tags = tags, resourceArn = resourceArn)
  output <- .ram$tag_resource_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$tag_resource <- ram_tag_resource

#' Removes the specified tag key and value pairs from the specified
#' resource share or managed permission
#'
#' @description
#' Removes the specified tag key and value pairs from the specified resource share or managed permission.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_untag_resource/](https://www.paws-r-sdk.com/docs/ram_untag_resource/) for full documentation.
#'
#' @param resourceShareArn Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share that you want to remove tags from. The tags are
#' removed from the resource share, not the resources in the resource
#' share. You must specify either `resourceShareArn`, or `resourceArn`, but
#' not both.
#' @param tagKeys &#91;required&#93; Specifies a list of one or more tag keys that you want to remove.
#' @param resourceArn Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the managed permission that you want to remove tags from. You must
#' specify either `resourceArn`, or `resourceShareArn`, but not both.
#'
#' @keywords internal
#'
#' @rdname ram_untag_resource
ram_untag_resource <- function(resourceShareArn = NULL, tagKeys, resourceArn = NULL) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/untagresource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$untag_resource_input(resourceShareArn = resourceShareArn, tagKeys = tagKeys, resourceArn = resourceArn)
  output <- .ram$untag_resource_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$untag_resource <- ram_untag_resource

#' Modifies some of the properties of the specified resource share
#'
#' @description
#' Modifies some of the properties of the specified resource share.
#'
#' See [https://www.paws-r-sdk.com/docs/ram_update_resource_share/](https://www.paws-r-sdk.com/docs/ram_update_resource_share/) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the resource share that you want to modify.
#' @param name If specified, the new name that you want to attach to the resource
#' share.
#' @param allowExternalPrincipals Specifies whether principals outside your organization in Organizations
#' can be associated with a resource share.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#'
#' @keywords internal
#'
#' @rdname ram_update_resource_share
ram_update_resource_share <- function(resourceShareArn, name = NULL, allowExternalPrincipals = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateResourceShare",
    http_method = "POST",
    http_path = "/updateresourceshare",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ram$update_resource_share_input(resourceShareArn = resourceShareArn, name = name, allowExternalPrincipals = allowExternalPrincipals, clientToken = clientToken)
  output <- .ram$update_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$update_resource_share <- ram_update_resource_share
