% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_confirm_forgot_password}
\alias{cognitoidentityprovider_confirm_forgot_password}
\title{This public API operation accepts a confirmation code that Amazon
Cognito sent to a user and accepts a new password for that user}
\usage{
cognitoidentityprovider_confirm_forgot_password(
  ClientId,
  SecretHash = NULL,
  Username,
  ConfirmationCode,
  Password,
  AnalyticsMetadata = NULL,
  UserContextData = NULL,
  ClientMetadata = NULL
)
}
\arguments{
\item{ClientId}{[required] The ID of the app client where the user wants to reset their password.
This parameter is an identifier of the client application that users are
resetting their password from, but this operation resets users'
passwords for all app clients in the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message. For more information about \code{SecretHash}, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#cognito-user-pools-computing-secret-hash}{Computing secret hash values}.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, this value must be the \code{sub} of a local user or the username
of a user from a third-party IdP.}

\item{ConfirmationCode}{[required] The confirmation code that your user pool sent in response to an
\code{\link[=cognitoidentityprovider_admin_reset_user_password]{admin_reset_user_password}}
or a \code{\link[=cognitoidentityprovider_forgot_password]{forgot_password}}
request.}

\item{Password}{[required] The new password that your user wants to set.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{\link[=cognitoidentityprovider_confirm_forgot_password]{confirm_forgot_password}}
calls.}

\item{UserContextData}{Contextual data about your user session, such as the device fingerprint,
IP address, or location. Amazon Cognito advanced security evaluates the
risk of an authentication event based on the context that your app
generates and passes to Amazon Cognito when it makes API requests.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-viewing-threat-protection-app.html}{Collecting data for threat protection in applications}.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

You create custom workflows by assigning Lambda functions to user pool
triggers. When you use the ConfirmForgotPassword API action, Amazon
Cognito invokes the function that is assigned to the \emph{post confirmation}
trigger. When Amazon Cognito invokes this function, it passes a JSON
payload, which the function receives as input. This payload contains a
\code{clientMetadata} attribute, which provides the data that you assigned to
the ClientMetadata parameter in your ConfirmForgotPassword request. In
your function code in Lambda, you can process the \code{clientMetadata} value
to enhance your workflow for your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-working-with-lambda-triggers.html}{Customizing user pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

When you use the \code{ClientMetadata} parameter, note that Amazon Cognito
won't do the following:
\itemize{
\item Store the \code{ClientMetadata} value. This data is available only to
Lambda triggers that are assigned to a user pool to support custom
workflows. If your user pool configuration doesn't include triggers,
the \code{ClientMetadata} parameter serves no purpose.
\item Validate the \code{ClientMetadata} value.
\item Encrypt the \code{ClientMetadata} value. Don't send sensitive information
in this parameter.
}}
}
\description{
This public API operation accepts a confirmation code that Amazon Cognito sent to a user and accepts a new password for that user.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_confirm_forgot_password/} for full documentation.
}
\keyword{internal}
