% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphkde.pg.R
\name{sphkde.pg}
\alias{sphkde.pg}
\title{sphkde.pg}
\usage{
sphkde.pg(datax, kappa = NULL, eval.points = NULL, guide = TRUE)
}
\arguments{
\item{datax}{Matrix containing the data in cartesian coordinates, where the number of rows is the number of observations and the number of columns is the dimension of the Euclidean space where the sphere is embebed.}

\item{kappa}{Smoothing parameter. It refers to the concentration when employing a von Mises-Fisher kernel.}

\item{eval.points}{Matrix containing the evaluation points for the estimation of the density.}

\item{guide}{Logical; if TRUE, the estimator with a von Mises-Fisher as guide is computed. If FALSE, the classical kernel density estimator without guide is computed (equivalent to uniform guide).}
}
\value{
An object with class "sphkde" whose underlying structure is a list containing the following components: \item{estim}{ The estimated values of the density.}
\item{kappa}{The smoothing parameter used.} \item{data}{The n coordinates of the points where the regression is estimated.}
\item{eval.points}{The points where the estimated density was evaluated.}
\item{data}{Original dataset.}
}
\description{
Function \code{sphkde.pg} computes the kernel density estimator for (hyper)spherical data with a parametric guide, which corresponds to the von Mises-Fisher model.
}
\details{
See Alonso-Pena et al. (2023) for details.
}
\examples{
library(movMF)
n<-200
mu<-matrix(c(0,0,1,0,0,-1),ncol=3,byrow=TRUE)
k<-c(7,2)
probs<-c(0.85,0.15)
datax<-rmovMF(n,k*mu,alpha=probs)
est<-sphkde.pg(datax,guide=TRUE)
sphkde.plot(est,type="sph")
}
\references{
Alonso-Pena, M., Claeskens, G. and Gijbels, I. (2023) Nonparametric estimation of densities on the hypersphere using a parametric guide. Under review.
}
