% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosshairGrob.R
\name{grid.crosshair}
\alias{grid.crosshair}
\alias{crosshairGrob}
\alias{segmentsCrosshairGrob}
\alias{squaresCrosshairGrob}
\title{Draw crosshairs with grid}
\usage{
crosshairGrob(
  ...,
  piece_side = "tile_back",
  suit = NA,
  rank = NA,
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  x = unit(0.5, "npc"),
  y = unit(0.5, "npc"),
  angle = 0,
  width = NA,
  height = NA,
  scale = 1,
  default.units = "npc",
  envir = getOption("piecepackr.envir"),
  name = NULL,
  gp = gpar(),
  vp = NULL,
  ch_width = unit(1/6, "in"),
  ch_grob = squaresCrosshairGrob()
)

grid.crosshair(..., draw = TRUE)

segmentsCrosshairGrob(
  ...,
  x = unit(0.5, "npc"),
  y = unit(0.5, "npc"),
  width = unit(1, "snpc"),
  height = unit(1, "snpc"),
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  vp = NULL
)

squaresCrosshairGrob(
  ...,
  x = unit(0.5, "npc"),
  y = unit(0.5, "npc"),
  width = unit(1, "snpc"),
  height = unit(1, "snpc"),
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  vp = NULL
)
}
\arguments{
\item{...}{\code{crosshairGrob()} ignores; \code{grid.crosshair()} passes to \code{crosshairGrob()}.}

\item{piece_side}{A string with piece and side separated by a underscore e.g. "coin_face"}

\item{suit}{Number of suit (starting from 1).}

\item{rank}{Number of rank (starting from 1)}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object,
a list of \code{pp_cfg} objects,
or a character vector referring to names in \code{envir}
or a character vector referring to object names that
can be retrieved by \code{base::dynGet()}.}

\item{x}{Where to place piece on x axis of viewport}

\item{y}{Where to place piece on y axis of viewport}

\item{angle}{Angle (on xy plane) to draw piece at}

\item{width}{Width of piece}

\item{height}{Height of piece}

\item{scale}{Multiplicative scaling factor to apply to width, height, and depth.}

\item{default.units}{A string indicating the default units to use if
'x', 'y', 'width', and/or 'height' are only given as numeric vectors.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{name}{A character identifier (for grid)}

\item{gp}{An object of class \dQuote{gpar}.}

\item{vp}{A \code{grid} viewport object (or \code{NULL}).}

\item{ch_width}{Width/height of \code{ch_grob}'s viewport.}

\item{ch_grob}{Crosshair grob.  Will be drawn in each corner of the piece in a viewport with \code{ch_width} width and \code{ch_width} height.
\code{segmentsCrosshairGrob()} simply wraps \code{\link[grid:grid.segments]{grid::segmentsGrob()}} while
\code{squaresCrosshairGrob()} wraps \code{\link[grid:grid.rect]{grid::rectGrob()}} and alternates
black/white squares for visibility on both light and dark backgrounds.}

\item{draw}{A logical value indicating whether graphics output should be produced.}
}
\value{
A grid grob.
}
\description{
\code{grid.crosshair()} draws crosshairs at the corners of a rectangular area.
\code{crosshairGrob()} is its grid grob counterpart.
They are intended for use in adding crosshairs at the corners of
game pieces in print-and-play layouts.
}
\details{
One can use the lower level \code{segmentsCrosshairGrob()} and \code{squaresCrosshairGrob()}
(which can be drawn with \code{\link[grid:grid.draw]{grid::grid.draw()}})
to add individual crosshairs to specified (x,y) locations.
}
\examples{
if (requireNamespace("grid", quietly = TRUE) &&
    piecepackr:::device_supports_unicode()) {
  cfg <- pp_cfg(list(border_color = NA))
  grid::grid.newpage()
  df <- data.frame(piece_side = "tile_face", suit = 2, rank = 2,
                   x = 2, y = 2, angle = 0,
                   stringsAsFactors = FALSE)
  pmap_piece(df, grid.piece, cfg = cfg, default.units = "in")
  pmap_piece(df, grid.crosshair, cfg = cfg, default.units = "in")
}
if (requireNamespace("grid", quietly = TRUE) &&
    piecepackr:::device_supports_unicode()) {
  grid::grid.newpage()
  pmap_piece(df, grid.piece, cfg = cfg, default.units = "in")
  pmap_piece(df, grid.crosshair, cfg = cfg, default.units = "in",
             ch_grob = segmentsCrosshairGrob())
}
}
