% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefs.plsR.raw.R
\name{coefs.plsR.raw}
\alias{coefs.plsR.raw}
\title{Raw coefficients for bootstrap computations of PLSR models}
\usage{
coefs.plsR.raw(dataset, ind, nt, modele, maxcoefvalues, ifbootfail, verbose)
}
\arguments{
\item{dataset}{dataset to resample}

\item{ind}{indices for resampling}

\item{nt}{number of components to use}

\item{modele}{type of modele to use, see \link{plsR}}

\item{maxcoefvalues}{maximum values allowed for the estimates of the
coefficients to discard those coming from singular bootstrap samples}

\item{ifbootfail}{value to return if the estimation fails on a bootstrap
sample}

\item{verbose}{should info messages be displayed ?}
}
\value{
estimates on a bootstrap sample or \code{ifbootfail} value if the
bootstrap computation fails.
}
\description{
A function passed to \code{boot} to perform bootstrap.
}
\examples{

data(Cornell)
XCornell<-Cornell[,1:7]
yCornell<-Cornell[,8]

# Lazraq-Cleroux PLS (Y,X) bootstrap
set.seed(250)
modpls <- coefs.plsR.raw(Cornell[,-8],1:nrow(Cornell),nt=3,
maxcoefvalues=1e5,ifbootfail=rep(0,3),verbose=FALSE)

}
\seealso{
See also \code{\link{bootpls}}.
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{models}
