% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_quantile.R
\name{normalize_quantile}
\alias{normalize_quantile}
\title{Quantile Normalization}
\usage{
normalize_quantile(omicsData)
}
\arguments{
\item{omicsData}{an object of the class 'pepData', 'proData', 'metabData',
'lipidData', 'nmrData', created by \code{\link{as.pepData}},
\code{\link{as.proData}}, \code{\link{as.metabData}},
\code{\link{as.lipidData}}, or \code{\link{as.nmrData}}, respectively.}
}
\value{
The normalized data is returned in an object of the appropriate S3
  class (e.g. pepData), on the same scale as omicsData (e.g. if omicsData
  contains log2 transformed data, the normalization will be performed on the
  non-log2 scale and then re-scaled after normalization to be returned on the
  log2 scale).
}
\description{
Perform quantile normalization
}
\details{
Quantile normalization is an algorithm for normalizing a set of data
  vectors by giving them the same distribution. It is applied to data on the
  abundance scale (e.g. not a log scale). It is often used for microarray
  data.

The method is implemented as described in Bolstad et al. (2003).
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
myfilt <- molecule_filter(omicsData = metab_object)
# quantile normalization requires complete data
# summary(myfilt, min_num = 50)
mymetab <- applyFilt(filter_object = myfilt, omicsData = metab_object, min_num = 50)
norm_data <- normalize_quantile(omicsData = mymetab)
\dontshow{\}) # examplesIf}
}
\references{
Bolstad, B. M., Irizarry, R. A., Åstrand, M., & Speed, T. P.
  (2003). A comparison of normalization methods for high density
  oligonucleotide array data based on variance and bias. Bioinformatics,
  19(2), 185-193.
}
\author{
Kelly Stratton
}
