% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpgnorm_rs.R
\name{rpgnorm_rs}
\alias{rpgnorm_rs}
\title{Random Variable From a Generalized Normal Distribution}
\usage{
rpgnorm_rs(n = 10, p = 2, pmean = 0, psd = 1)
}
\arguments{
\item{n}{The number of random numbers
to generate.}

\item{p}{The parameter of the
distribution. Must be a positive
non-zero number. Default is 2,
resulting in a normal distribution.
Higher than 2 results in negative
excess kurtosis. Lower than 2 results
in positive excess kurtosis.}

\item{pmean}{Population mean.}

\item{psd}{Population standard
deviation.}
}
\value{
A vector of the generated
random numbers.
}
\description{
Generate random numbers
from generalized normal distribution,
rescaled to have user-specified
population mean and standard
deviation.
}
\details{
First, specify the parameter \code{p}
and the desired population
mean and standard deviation. The
random numbers, drawn from a
generalized normal distribution by
\code{\link[pgnorm:rpgnorm]{pgnorm::rpgnorm()}}, will then be
rescaled with the desired population
mean and standard.
}
\examples{
set.seed(90870962)
x <- rpgnorm_rs(n = 5000,
                p = 2,
                pmean = 0,
                psd = 1)
mean(x)
sd(x)
hist(x)
x_kurt <- function(p) {gamma(5/p)*gamma(1/p)/(gamma(3/p)^2) - 3}

p <- 6
x <- rpgnorm_rs(n = 50000,
                p = p,
                pmean = 0,
                psd = 1)
mean(x)
sd(x)
x_kurt(p)
qqnorm(x); qqline(x)

p <- 1
x <- rpgnorm_rs(n = 50000,
                p = p,
                pmean = 0,
                psd = 1)
mean(x)
sd(x)
x_kurt(p)
qqnorm(x); qqline(x)
}
