% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcens.R
\name{new_pcens}
\alias{new_pcens}
\title{S3 class for primary event censored distribution computation}
\usage{
new_pcens(
  pdist,
  dprimary,
  dprimary_args,
  pdist_name = NULL,
  dprimary_name = NULL,
  ...
)
}
\arguments{
\item{pdist}{Distribution function (CDF)}

\item{dprimary}{Function to generate the probability density function
(PDF) of primary event times. This function should take a value \code{x} and a
\code{pwindow} parameter, and return a probability density. It should be
normalized to integrate to 1 over [0, pwindow]. Defaults to a uniform
distribution over [0, pwindow]. Users can provide custom functions or use
helper functions like \code{dexpgrowth} for an exponential growth distribution.
See \code{primary_dists.R} for examples.}

\item{dprimary_args}{List of additional arguments to be passed to
dprimary. For example, when using \code{dexpgrowth}, you would
pass \code{list(min = 0, max = pwindow, r = 0.2)} to set the minimum, maximum,
and rate parameters}

\item{pdist_name}{A string specifying the name of the delay distribution
function. If NULL, the function name is extracted using
\code{\link[=.extract_function_name]{.extract_function_name()}}. Used to determine if a analytical solution
exists for the primary censored distribution. Must be set if \code{pdist} is
passed a pre-assigned variable rather than a function name.}

\item{dprimary_name}{A string specifying the name of the primary event
distribution function. If NULL, the function name is extracted using
\code{\link[=.extract_function_name]{.extract_function_name()}}. Used to determine if a analytical solution
exists for the primary censored distribution. Must be set if \code{dprimary} is
passed a pre-assigned variable rather than a function name.}

\item{...}{Additional arguments to be passed to pdist}
}
\value{
An object of class \verb{pcens_\{pdist_name\}_\{dprimary_name\}}. This
contains the primary event distribution, the delay distribution, the
delay distribution arguments, and any additional arguments. It can be
used with the \code{pcens_cdf()} function to compute the primary event censored
cdf.
}
\description{
S3 class for primary event censored distribution computation
}
\seealso{
Low level primary event censored distribution objects and methods
\code{\link{pcens_cdf}()},
\code{\link{pcens_cdf.default}()},
\code{\link{pcens_cdf.pcens_pgamma_dunif}()},
\code{\link{pcens_cdf.pcens_plnorm_dunif}()}
}
\concept{pcens}
