% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence.R
\name{get_sequences}
\alias{get_sequences}
\title{Retrieves fasta sequences from NCBI nucleotide database.}
\usage{
get_sequences(
  accession,
  start = NULL,
  stop = NULL,
  api_key = Sys.getenv("NCBI_API_KEY"),
  simplify = TRUE,
  .parallel = FALSE,
  .progress = "none"
)
}
\arguments{
\item{accession}{the accession number of the sequence to retrieve}

\item{start}{start bases to retrieve, numbered beginning at 1.  If NULL the
beginning of the sequence.}

\item{stop}{stop bases to retrieve, numbered beginning at 1. if NULL the stop of
the sequence.}

\item{api_key}{NCBI api-key to allow faster sequence retrieval.}

\item{simplify}{simplify the FASTA headers to include only the genbank
accession.}

\item{.parallel}{if 'TRUE', perform in parallel, using parallel backend
provided by foreach}

\item{.progress}{name of the progress bar to use, see 'create_progress_bar'}
}
\value{
an DNAbin object.
}
\description{
Retrieves fasta sequences from NCBI nucleotide database.
}
\seealso{
\code{\link{DNAbin}}
}
