% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prism_archive_subset.R
\name{prism_archive_subset}
\alias{prism_archive_subset}
\title{Subsets PRISM folders on the disk}
\usage{
prism_archive_subset(
  type,
  temp_period,
  years = NULL,
  mon = NULL,
  minDate = NULL,
  maxDate = NULL,
  dates = NULL,
  resolution = NULL
)
}
\arguments{
\item{type}{The type of data you want to subset. Must be "ppt", "tmean",
"tmin", "tmax", "tdmean", "vpdmin", or "vpdmax".}

\item{temp_period}{The temporal period to subset. Must be "annual",
"monthly", "daily", "monthly normals", or "annual normals".}

\item{years}{Valid numeric year, or vector of years.}

\item{mon}{Valid numeric month, or vector of months.}

\item{minDate}{Date to start subsetting daily data. Must be specified in
a valid iso-8601 (e.g. YYYY-MM-DD) format. May be provided as either a
character or \link[base:Dates]{base::Date} class.}

\item{maxDate}{Date to end subsetting daily data.  Must be specified in
a valid iso-8601 (e.g. YYYY-MM-DD) format. May be provided as either a
character or \link[base:Dates]{base::Date} class.}

\item{dates}{A vector of daily dates to subset. Must be specified in
a valid iso-8601 (e.g. YYYY-MM-DD) format. May be provided as either a
character or \link[base:Dates]{base::Date} class.}

\item{resolution}{The spatial resolution of the data, must be either "4km" or
"800m". Should only be specified for \code{temp_period} of "normals".}
}
\value{
A character vector of the folders that meet the type and temporal
period specified. \code{character(0)} is returned if no folders are found that
meet the specifications.
}
\description{
\code{prism_archive_subset()} subsets the PRISM folders stored on disk by type,
temporal period, and date. It looks through all of the PRISM data that have
been downloaded in the prism archive (\code{\link[=prism_get_dl_dir]{prism_get_dl_dir()}}) and returns the
subset based on the specified \code{type}, \code{temp_period}, and dates.
}
\details{
\code{temp_period} must be specified so the function can distinguish between
wanting annual data or wanting monthly data for a specified year. For example
\code{prism_archive_subset("tmean", "annual", years = 2012)} would provide only
one folder: the annual average temperature for 2012. However,
\code{prism_archive_subset("tmean", "monthly", years = 2012)} would provide 12
folders: each monthly tmean folder for 2012.

\code{temp_period}, \code{years}, and \code{mon} can be combined in various different ways
to obtain different groupings of data. \code{years}, \code{mon}, and the daily
specifiers (\code{minDate}/\code{maxDate} or \code{dates}) are optional. Not specifying any
of those would result in getting all annual, monthly, or daily data.

\code{minDate}/\code{maxDate} or \code{dates} should only be specified for a \code{temp_period}
of "daily". Additionally, only \code{dates}, or \code{minDate} and \code{maxDate}, should be
specified, but all three should not be specified. Nor should the daily
arguments be combined with \code{years} and/or \code{mon}. For example, if daily
folders are desired, then specify \code{years} and/or \code{mon} to get all days for
those years and months \strong{or} specify the specific dates using
\code{minDate}/\code{maxDate} or \code{dates}
}
\examples{
\dontrun{
# get all annual tmin
prism_archive_subset("tmin", "annual")
# get only 2000-2015 annual tmin
prism_subset_folder("tmin", "annual", years = 2000-2015)

# get monthly precipitation for 2000-2010
prism_archive_subset("ppt", "monthly", years = 2000-2010)
# get only June-August monthly precip data for 2000-2010
prism_archive_subset("ppt", "monthly", years = 2000-2010, mon = 6:8)

# get all daily tmax for July-August in 2010
prism_archive_subset("tmax", "daily", years = 2010, mon = 7:8)
# same as:
prism_archive_subset(
  "tmax", 
  "daily", 
  minDate = "2010-07-01", 
  maxDate = "2010-08-31"
)

# get the 4km 30-year average precip for January and February
prism_archive_subset("ppt", "monthly normals", mon = 1:2, resolution = "4km")
}

}
\seealso{
\code{\link[=prism_archive_ls]{prism_archive_ls()}}
}
