% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/prior_class.R, R/prior_normal.R,
%   R/prior_exponential.R, R/prior_half_cauchy.R, R/prior_bernoulli.R,
%   R/prior_beta.R, R/prior_cauchy.R, R/prior_gamma.R, R/prior_half_normal.R,
%   R/prior_poisson.R, R/uniform_prior.R
\name{plot}
\alias{plot}
\alias{plot,Prior,missing-method}
\alias{plot,PriorNormal,missing-method}
\alias{plot,PriorExponential,missing-method}
\alias{plot,PriorHalfCauchy,missing-method}
\alias{plot,PriorBernoulli,missing-method}
\alias{plot,PriorBeta,missing-method}
\alias{plot,PriorCauchy,missing-method}
\alias{plot,PriorGamma,missing-method}
\alias{plot,PriorHalfNormal,missing-method}
\alias{plot,PriorPoisson,missing-method}
\alias{plot,UniformPrior,missing-method}
\title{Plot Prior Objects}
\usage{
\S4method{plot}{Prior,missing}(
  x,
  y,
  default_limits,
  dist_type = c("continuous", "discrete"),
  density_fun,
  add,
  ...
)

\S4method{plot}{PriorNormal,missing}(x, y, add = FALSE, ...)

\S4method{plot}{PriorExponential,missing}(x, y, add = FALSE, ...)

\S4method{plot}{PriorHalfCauchy,missing}(x, y, add = FALSE, ...)

\S4method{plot}{PriorBernoulli,missing}(x, y, add = FALSE, ...)

\S4method{plot}{PriorBeta,missing}(x, y, add = FALSE, ...)

\S4method{plot}{PriorCauchy,missing}(x, y, add = FALSE, ...)

\S4method{plot}{PriorGamma,missing}(x, y, add = FALSE, ...)

\S4method{plot}{PriorHalfNormal,missing}(x, y, add = FALSE, ...)

\S4method{plot}{PriorPoisson,missing}(x, y, add = FALSE, ...)

\S4method{plot}{UniformPrior,missing}(x, y, add = FALSE, ...)
}
\arguments{
\item{x}{Object inheriting from \code{Prior}}

\item{y}{Not used.}

\item{default_limits}{Numeric range to plot distribution over.}

\item{dist_type}{Plot a continuous or discrete distribution.}

\item{density_fun}{Function which takes a vector of values and returns a vector of density values.}

\item{add}{logical. Add density to existing plot.}

\item{...}{Optional arguments for plotting.}
}
\value{
No return value, this function generates a plot in the current graphics device.
}
\description{
Plot prior distributions as densities. Continuous distributions are plotted as curves and
discrete distributions as bar plots.
}
\details{
Plot ranges are selected by default to show 99\% of the density for unbounded distributions.
The limits can be changed by specifying \code{xlim = c(lower, upper)}.

Colors, line types, and other typical \code{\link[=par]{par()}} parameters can be used.
}
\examples{
plot(prior_normal(1, 2))
plot(prior_exponential(0.1))
plot(prior_half_cauchy(0, 1), xlim = c(-20, 20))
plot(prior_half_cauchy(0, 2), xlim = c(-20, 20), col = 2, add = TRUE)
plot(prior_bernoulli(0.4), xlim = c(0, 15))
plot(prior_beta(2, 2))
plot(prior_cauchy(0, 1), xlim = c(-20, 20))
plot(prior_cauchy(0, 2), xlim = c(-20, 20), col = 2, add = TRUE)
plot(prior_gamma(0.1, 0.1))
plot(prior_half_normal(0, 1), xlim = c(-20, 20))
plot(prior_half_normal(0, 2), xlim = c(-20, 20), col = 2, add = TRUE)
plot(prior_poisson(5), xlim = c(0, 15))
plot(uniform_prior(1, 2), xlim = c(0, 3))
}
