% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{modulo_floor}
\alias{modulo_floor}
\title{Nearest value below}
\usage{
modulo_floor(n, m = 2L)
}
\arguments{
\item{n}{integer; the number of terms (can be a vector)}

\item{m}{integer; the modulo term (cannot be zero)}
}
\description{
Returns the nearest \code{m}-length value (downwards from \code{n}).
}
\details{
This function is different from \code{\link{nextn}} in that the value is floored.
For example:
\code{10} is the result for \code{n=11,m=2} whereas \code{\link{nextn}} would give \code{12}.
}
\examples{
n <- 11
nextn(n) # 12
modulo_floor(n) # 10

# works on vectors too:
# defaults to m=2
modulo_floor(seq_len(n))
#[1]  0  2  2  4  4  6  6  8  8 10 10

# change the floor factor
modulo_floor(seq_len(n), 3)
#[1] 0 0 3 3 3 6 6 6 9 9 9

# zeros are not allowed for m
try(modulo_floor(n, 0))

}
\seealso{
\code{\link{psd-utilities}}; \code{\link{psdcore}} uses this to 
truncate series to their nearest even length (i.e., \code{m=2}).
}
\author{
A.J. Barbour
}
