\name{qRandomSeq}
\alias{qRandomSeq}
\title{Demo data of true random numbers}
\description{
  \code{qRandomSeq} is a sample of 1,000 true random numbers, which are generated by measuring the quantum fluctuations of the vacuum. The sequence of numbers is provided by the \href{https://qrng.anu.edu.au/}{ANU Quantum Random Number Generator} of the Australian National University.
}
\usage{
data(qRandomSeq)
}

\details{
\code{qRandomSeq} is a list containing 1,000 observations of true random numbers for each of the data-types provided by the official \href{https://qrng.anu.edu.au/contact/api-documentation/}{QRNG@ANU API}. The data type
\itemize{
  \item \code{uint8} returns uniformly distributed integers from the interval \eqn{[0; 255]}.
  \item \code{uint16} returns uniformly distributed integers from the interval \eqn{[0; 65,535]}.
  \item \code{hex16} returns uniformly distributed hexadecimal characters from the interval \eqn{[00; ff]}.
}
}

\examples{
## load qRandomSeq
data(qRandomSeq)

## calculate the mean of the 1,000 random numbers
## with data-type uint8
mean(qRandomSeq$uint8)
}
