% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{o311_api}
\alias{o311_api}
\title{Select an open311 API}
\usage{
o311_api(
  endpoint = NULL,
  jurisdiction = NULL,
  key = NULL,
  format = c("json", "xml")
)
}
\arguments{
\item{endpoint}{\code{[character]}

Name of an endpoint that runs an open311 API. This is usually a
city, but can be any provider of an open311 API.}

\item{jurisdiction}{\code{[character]}

ID of a jurisdiction that is served by an open311 API. A jurisdiction
ID is usually the root URL of the jurisdiction website, e.g.
\code{"sandiego.gov"} for San Diego.}

\item{key}{\code{[character]}

If a key is required by the selected API, this argument can be used to
store the key in the R session. The API key is automatically used in
API requests. If \code{key} is \code{NULL} although a key is required,
a warning is emitted.}

\item{format}{\code{[character]}

Response format. Must be one of \code{"json"} or \code{"xml"}. Defaults to
\code{"json"} because simplification is more difficult and unsafe for
\code{xml2} objects. It is advisable to use \code{"json"} whenever
possible and applicable. Additionally, \code{"xml"} requires the
\code{xml2} package for queries and the \code{xmlconvert} package for
simplification.}
}
\value{
A list containing the most important information on a given
jurisdiction, invisibly. This list is attached to the session and can
be retrieved by calling \code{o311_api()} without arguments. Passing no
arguments returns the currently attached API object.
}
\description{
Select an open311 API and attach it to the active session. An open311 API is
an implementation of the open311 standard. It consists of an endpoint name
(e.g. a city), a root URL, and a jurisdiction ID. To unambiguously identify
an API, you can provide an endpoint, a jurisdiction ID, or both. The input
is matched with \code{\link{o311_endpoints}} to select an API. The
selected API is available to other \code{o311_*} functions until the
session is terminated or until it is overwritten.
}
\details{
In theory, several jurisdictions can exist for a single endpoints, e.g.
if a region serves multiple jurisdictions. Similarly, multiple endpoints
can exist for a single jurisdiction, e.g. if a provider has set up both
production and test endpoints for a jurisdictions. Providing both
endpoint and jurisdiction is thus the most safe way to identify an API.

By default, only a handful of endpoints are supported. For a list of
currently supported endpoints, run \code{\link{o311_endpoints}}. You can
add non-default endpoints using \code{\link{o311_add_endpoint}}.
}
\examples{
# cities are matched using regex
o311_api("Cologne")

# passing a jurisdiction is more explicit
o311_api(jurisdiction = "stadt-koeln.de")

# calls without arguments return the current API
o311_api()
}
\seealso{
\code{\link{o311_requests}}, \code{\link{o311_request}},
\code{\link{o311_services}}
}
