% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{growthFunction}
\alias{growthFunction}
\title{This is a wrapper function where the birth and death related parameters of a SHAPE run are passed before the
appropriate functions (and their associated methods) are called.  This function will be called once per time step
of a SHAPE run.}
\usage{
growthFunction(func_inSize, func_inFitness, func_bProb, func_dProb,
  func_deathDen_logical = FALSE, func_deathDen_max = NULL,
  func_deathDen_power = 4, func_sizeStep,
  func_growthForm = c("logistic", "exponential", "constant", "poisson"),
  func_carryingCapacity = NULL, func_basalRate = NULL,
  func_deathScale = FALSE, func_drift = TRUE,
  func_roundValues = FALSE, func_inIDs = NULL)
}
\arguments{
\item{func_inSize}{This is the vector of population sizes within the community}

\item{func_inFitness}{This is the vector of fitness value for the community}

\item{func_bProb}{This is the general bith probability defined for this run of SHAPE}

\item{func_dProb}{This is the general death probability defined for this run of SHAPE}

\item{func_deathDen_logical}{This is a logical toggle to define if deaths are calculated
in a density dependent manner.}

\item{func_deathDen_max}{This is the community size at which maximum density dependent deaths
(ie: 100\% of func_inSize) occur.}

\item{func_deathDen_power}{This is a scaling factor that controls the rate of transition between
minimal and maximal values of the density dependent deaths.  Higher values mean a steeper transition
such that there are fewer deaths until higher densities are reached.}

\item{func_sizeStep}{This is a proportional scalar that will control what proportion of a standard
"generation" is simulated for each step within a SHAPE run.  NOTE: This parameter is not perfectly
validated to run as may be expected with all models.  For now, it should be left as a value of "1",
but exists for future implementation and testing.}

\item{func_growthForm}{This is the implemeted growth model to be simulated in this run.  Currently
this can be one of \strong{"logistic","exponential","constant","poisson"}.}

\item{func_carryingCapacity}{This is the maximum community size supported by tge simulated environment.}

\item{func_basalRate}{This is the basal growth rate, otherwise definable as the number of offspring
an individual will produce from a single birth event.}

\item{func_deathScale}{This is a logical toggle to define if the number of births should be scaled
by the number of deaths.  The exact interpretation of this varies by growth model, but in general
it forces growth to follow rates expected by standard pure birth models while still simulating
deaths within the community.}

\item{func_drift}{This is a logical toggle as to whether or not stochasticity is introduced into
the deterministic calculations that may be encountered within the growth function.  Its exact
implementation varies based on the growth model being simulated.}

\item{func_roundValues}{This is a logical toggle to define if the number of births and deaths are
forced to be tracked as integer values.  If TRUE, then any fractional amounts will be stochastically
rounded to the nearest integer with a probability of being rounded up equal to the decimal value
-- ie: 0.32 means 32\% chance of being rounded up --}

\item{func_inIDs}{This is a vector of the genotype IDs passed to this function, its order should
be representative of the ordered genotypeIDs passed for func_inSize and func_inFitness.}
}
\value{
A 2 column matrix of numeric values with columns "births" and "deaths", and rownames equal
to func_inIDs (as.character).
}
\description{
This is a wrapper function where the birth and death related parameters of a SHAPE run are passed before the
appropriate functions (and their associated methods) are called.  This function will be called once per time step
of a SHAPE run.
}
\examples{
# Imagine you've got an evolving community of three populations where
# in each time step 100\% of individuals die and individuals with relateive
# fitness of 1 produce 2 offspring.  This growth function calculates the births
# and deaths of that community.
# First I show you when births are deterministic (proof of implementation):
growthFunction(func_inSize = c(100,100,100), func_inFitness = c(1,2,1.05),
                  func_bProb = 1, func_dProb = 1,
                  func_sizeStep = 1, func_growthForm = "exponential",
                  func_drift = FALSE, func_deathScale = TRUE)
# Now same things but with evolutionary drift thrown in
growthFunction(func_inSize = c(100,100,100), func_inFitness = c(1,2,1.05),
               func_bProb = 1, func_dProb = 1, func_sizeStep = 1,
               func_growthForm = "exponential", func_drift = TRUE,
               func_deathScale = TRUE)
# Now technically the values in the birth column is really the net population
# size and I'd previously set the births to be scaled by deaths but if this were
# not the case you'd get final population sizes of:
growthFunction(func_inSize = c(100,100,100), func_inFitness = c(1,2,1.05),
                   func_bProb = 1, func_dProb = 1, func_sizeStep = 1,
                   func_growthForm = "exponential", func_drift = TRUE,
                   func_deathScale = FALSE)

}
