% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_movie.R
\name{render_movie}
\alias{render_movie}
\title{Render Movie}
\usage{
render_movie(filename, type = "orbit", frames = 360, fps = 30,
  phi = 30, theta = 0, zoom = NULL, fov = NULL, ...)
}
\arguments{
\item{filename}{Filename. If not appended with `.mp4`, it will be appended automatically.}

\item{type}{Default `orbit`, which orbits the 3D object at the user-set camera settings `phi`, `zoom`, and `fov`. 
Other options are `oscillate` (sine wave around `theta` value, covering 90 degrees), or `custom` (which uses the values from the 
`theta`, `phi`, `zoom`, and `fov` vectors passed in by the user).}

\item{frames}{Default `360`. Number of frames to render.}

\item{fps}{Default `30`. Frames per second. Recommmend either 30 or 60 for web.}

\item{phi}{Default `30`. Azimuth values, in degrees.}

\item{theta}{Default `0`. Theta values, in degrees.}

\item{zoom}{Defaults to the current view. Zoom value, between `0` and `1`.}

\item{fov}{Defaults to the current view. Field of view values, in degrees.}

\item{...}{Additional parameters to pass to av::av_capture_graphics}
}
\description{
Renders a movie using the \pkg{av} package. Moves the camera around a 3D visualization 
using either a standard orbit, or accepts vectors listing user-defined values for each camera parameter. If the latter,
the values must be equal in length to `frames` (or of length `1`, in which the value will be fixed).
}
\examples{
filename_movie = tempfile()

#By default, the function produces a 12 second orbit at 30 frames per second, at 30 degrees azimuth.
\donttest{
montereybay \%>\%
 sphere_shade(texture="imhof1") \%>\%
 plot_3d(montereybay, zscale=50, water = TRUE, watercolor="imhof1", 
         waterlinecolor="white", waterlinealpha=0.5)
#Un-comment the following to run:
#render_movie(filename = filename_movie)
}    
filename_movie = tempfile()

#You can change to an oscillating orbit. The magnification is increased and azimuth angle set to 30.
\donttest{
montereybay \%>\%
 sphere_shade(texture="imhof1") \%>\%
 plot_3d(montereybay, zscale=50, water = TRUE, watercolor="imhof1", 
         waterlinecolor="white", waterlinealpha=0.5)
#Un-comment the following to run:
#render_movie(filename = filename_movie, type = "oscillate", 
#             frames = 60,  phi = 30, zoom = 0.8, theta = -90)
}             
filename_movie = tempfile()

#Finally, you can pass your own set of values to the 
#camera parameters as a vector with type = "custom".

phivechalf = 30 + 60 * 1/(1 + exp(seq(-7, 20, length.out = 180)/2))
phivecfull = c(phivechalf, rev(phivechalf))
thetavec = -90 + 60 * sin(seq(0,359,length.out = 360) * pi/180)
zoomvec = 0.45 + 0.2 * 1/(1 + exp(seq(-5, 20, length.out = 180)))
zoomvecfull = c(zoomvec, rev(zoomvec))
\donttest{
montereybay \%>\%
 sphere_shade(texture="imhof1") \%>\%
 plot_3d(montereybay, zscale=50, water = TRUE, watercolor="imhof1", 
         waterlinecolor="white", waterlinealpha=0.5)
#Un-comment the following to run
#render_movie(filename = filename_movie, type = "custom", 
#             frames = 360,  phi = phivecfull, zoom = zoomvecfull, theta = thetavec)
}
}
