% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_credentials.R
\name{set_credentials}
\alias{set_credentials}
\title{Store credentials to the .Rprofile}
\usage{
set_credentials(
  given = NULL,
  family = NULL,
  email = NULL,
  orcid = NULL,
  protocol = NULL
)
}
\arguments{
\item{given}{A character of length 1. The given name of the project
maintainer.}

\item{family}{A character of length 1. The family name of the project
maintainer.}

\item{email}{A character of length 1. The email address of the project
maintainer.}

\item{orcid}{A character of length 1. The ORCID of the project maintainer.}

\item{protocol}{A character of length 1. The GIT protocol used to
communicate with the GitHub remote. One of \code{'https'} or \code{'ssh'}. If you
don't know, keep the default value (i.e. \code{NULL}) and the protocol will be
\code{'https'}.}
}
\value{
No return value.
}
\description{
This function is used to store user credentials in the \code{.Rprofile} file.
Accepted credentials are listed below. This function is useful if user
creates a lot of packages and/or research compendiums.

If the \code{.Rprofile} file does not exist this function will create it. Users
need to paste the content of the clipboard to this file.
}
\examples{
\dontrun{
library(rcompendium)


## Define **ONCE FOR ALL** your credentials ----

set_credentials("John", "Doe", "john.doe@domain.com", 
                orcid = "9999-9999-9999-9999", protocol = "https")
}
}
\seealso{
Other setup functions: 
\code{\link{new_compendium}()},
\code{\link{new_package}()},
\code{\link{refresh}()}
}
\concept{setup functions}
