% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReportService.R
\name{dfp_getReportJobStatus}
\alias{dfp_getReportJobStatus}
\title{getReportJobStatus}
\usage{
dfp_getReportJobStatus(request_data, as_df = FALSE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getReportJobStatusResponse
}
\description{
Returns the ReportJobStatus of the report job with the specified ID. Returns the ReportJobStatus of the report job with the specified ID. Returns the ReportJobStatus of the report job with the specified ID.
}
\examples{
\dontrun{
request_data <- list(reportJob=
                       list(reportQuery=
                              list(dimensions='MONTH_AND_YEAR', 
                                   dimensions='AD_UNIT_ID',
                                   adUnitView='FLAT',
                                   columns='AD_SERVER_CLICKS', 
                                   dateRangeType='LAST_WEEK')))

# the result is a list and most importantly the ID is included for checking its status
dfp_runReportJob_result <- dfp_runReportJob(request_data)

request_data <- list(reportJobId=dfp_runReportJob_result$id)
dfp_getReportJobStatus_result <- dfp_getReportJobStatus(request_data)
dfp_getReportJobStatus_result

# a simple while loop can keep checking a long running request until ready
counter <- 0
while(dfp_getReportJobStatus_result != 'COMPLETED' & counter < 10){
  dfp_getReportJobStatus_result <- dfp_getReportJobStatus(request_data)
  Sys.sleep(3)
  counter <- counter + 1
}
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/ReportService#getReportJobStatus}{Google Documentation for getReportJobStatus}
}
