/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.connectivity;

import java.util.BitSet;
import java.util.Iterator;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.UGVarConnectivityHelper;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropNbCC
extends Propagator<Variable> {
    private final UndirectedGraphVar g;
    private final IntVar k;
    private final UGVarConnectivityHelper helper;
    private final BitSet visitedMin;
    private final BitSet visitedMax;
    private final int[] fifo;
    private final int[] ccOf;

    public PropNbCC(UndirectedGraphVar graph, IntVar k) {
        super(new Variable[]{graph, k}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.k = k;
        this.helper = new UGVarConnectivityHelper(this.g);
        this.visitedMin = new BitSet(this.g.getNbMaxNodes());
        this.visitedMax = new BitSet(this.g.getNbMaxNodes());
        this.fifo = new int[this.g.getNbMaxNodes()];
        this.ccOf = new int[this.g.getNbMaxNodes()];
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        block9: {
            int j;
            ISetIterator iSetIterator;
            int i;
            int max;
            block10: {
                this.k.updateBounds(0, this.g.getPotentialNodes().size(), this);
                if (this.k.getUB() == 0) {
                    ISetIterator iSetIterator2 = this.g.getPotentialNodes().iterator();
                    while (iSetIterator2.hasNext()) {
                        int i2 = (Integer)iSetIterator2.next();
                        this.g.removeNode(i2, this);
                    }
                    return;
                }
                int min = this.minCC();
                max = this.maxCC();
                this.k.updateLowerBound(min, (ICause)this);
                this.k.updateUpperBound(max, (ICause)this);
                if (min == max) break block9;
                if (this.k.getUB() != min) break block10;
                int n = this.g.getNbMaxNodes();
                Iterator<Integer> iterator = this.g.getPotentialNodes().iterator();
                while (iterator.hasNext()) {
                    int o = (Integer)iterator.next();
                    if (this.visitedMin.get(o)) continue;
                    this.g.removeNode(o, this);
                }
                this.helper.computeMandatoryArticulationPointsAndBridges();
                iterator = this.helper.getArticulationPoints().iterator();
                while (iterator.hasNext()) {
                    int ap = (Integer)iterator.next();
                    this.g.enforceNode(ap, this);
                }
                for (int[] bridge : this.helper.getBridges()) {
                    this.g.enforceEdge(bridge[0], bridge[1], this);
                }
                break block9;
            }
            if (this.k.getLB() != max) break block9;
            ISet mNodes = this.g.getMandatoryNodes();
            ISetIterator iSetIterator3 = this.g.getPotentialNodes().iterator();
            while (iSetIterator3.hasNext()) {
                i = (Integer)iSetIterator3.next();
                if (mNodes.contains(i)) continue;
                iSetIterator = this.g.getPotentialNeighborsOf(i).iterator();
                while (iSetIterator.hasNext()) {
                    j = (Integer)iSetIterator.next();
                    this.g.removeEdge(i, j, this);
                }
                this.g.enforceNode(i, this);
            }
            iSetIterator3 = this.g.getPotentialNodes().iterator();
            while (iSetIterator3.hasNext()) {
                i = (Integer)iSetIterator3.next();
                iSetIterator = this.g.getPotentialNeighborsOf(i).iterator();
                while (iSetIterator.hasNext()) {
                    j = (Integer)iSetIterator.next();
                    if (this.ccOf[i] == this.ccOf[j]) continue;
                    this.g.removeEdge(i, j, this);
                }
            }
        }
    }

    private int minCC() {
        int min = 0;
        this.visitedMin.clear();
        ISetIterator iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.visitedMin.get(i)) continue;
            this.helper.exploreFrom(i, this.visitedMin);
            ++min;
        }
        return min;
    }

    private int maxCC() {
        int nbK = 0;
        this.visitedMax.clear();
        ISetIterator iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.visitedMax.get(i)) continue;
            this.exploreLBFrom(i, this.visitedMax);
            ++nbK;
        }
        int delta = this.g.getPotentialNodes().size() - this.g.getMandatoryNodes().size();
        return nbK + delta;
    }

    private void exploreLBFrom(int root, BitSet visited) {
        int first = 0;
        int last = 0;
        int i = root;
        this.fifo[last++] = i;
        visited.set(i);
        this.ccOf[i] = root;
        while (first < last) {
            i = this.fifo[first++];
            ISetIterator iSetIterator = this.g.getMandatoryNeighborsOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (visited.get(j)) continue;
                visited.set(j);
                this.ccOf[j] = root;
                this.fifo[last++] = j;
            }
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.k.getUB() < this.minCC() || this.k.getLB() > this.maxCC()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

