/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.linkedlist;

import org.chocosolver.util.objects.setDataStructures.AbstractSet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_LinkedList
extends AbstractSet {
    private IntCell first;
    private IntCell last;
    private int size;
    private IntCell poolGC;
    private final ISetIterator iter = this.newIterator();

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(int element) {
        IntCell cell = this.first;
        while (cell != null) {
            if (cell.element == element) {
                return true;
            }
            cell = cell.next;
        }
        return false;
    }

    @Override
    public boolean add(int element) {
        if (this.contains(element)) {
            return false;
        }
        if (this.poolGC == null) {
            this.first = new IntCell(element, this.first);
        } else {
            IntCell recycled = this.poolGC;
            this.poolGC = this.poolGC.next;
            recycled.init(element, this.first);
            this.first = recycled;
        }
        if (this.last == null) {
            assert (this.size == 0);
            this.last = this.first;
        }
        ++this.size;
        this.notifyObservingElementAdded(element);
        return true;
    }

    @Override
    public boolean remove(int element) {
        if (this.first == null) {
            return false;
        }
        if (this.first.element == element) {
            this.iter.notifyRemoving(element);
            this.first = this.first.next;
            if (this.first == null) {
                this.last = null;
            }
            --this.size;
            this.notifyObservingElementRemoved(element);
            return true;
        }
        IntCell previous = this.first;
        IntCell current = this.first.next;
        while (current != null) {
            if (current.element == element) {
                this.iter.notifyRemoving(element);
                previous.next = current.next;
                if (previous.next == null) {
                    this.last = previous;
                }
                current.next = this.poolGC;
                this.poolGC = current;
                --this.size;
                this.notifyObservingElementRemoved(element);
                return true;
            }
            previous = current;
            current = current.next;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.first != null) {
            this.last.next = this.poolGC;
            this.poolGC = this.first;
        }
        this.first = null;
        this.last = null;
        this.size = 0;
        this.notifyObservingCleared();
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find minimum of an empty set");
        }
        IntCell current = this.first;
        int min = current.element;
        while (current.next != null) {
            if (min <= (current = current.next).element) continue;
            min = current.element;
        }
        return min;
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find maximum of an empty set");
        }
        IntCell current = this.first;
        int max = current.element;
        while (current.next != null) {
            if (max >= (current = current.next).element) continue;
            max = current.element;
        }
        return max;
    }

    @Override
    public SetType getSetType() {
        return SetType.LINKED_LIST;
    }

    @Override
    public ISetIterator iterator() {
        this.iter.reset();
        return this.iter;
    }

    @Override
    public ISetIterator newIterator() {
        return new ISetIterator(){
            int r = 0;
            private IntCell nextCell = Set_LinkedList.access$200(Set_LinkedList.this);

            @Override
            public void reset() {
                this.nextCell = Set_LinkedList.this.first;
                ++this.r;
            }

            @Override
            public void notifyRemoving(int item) {
                if (this.nextCell != null && this.nextCell.element == item) {
                    this.nextCell = this.nextCell.next;
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextCell != null;
            }

            @Override
            public int nextInt() {
                int e = this.nextCell.element;
                this.nextCell = this.nextCell.next;
                return e;
            }
        };
    }

    private class IntCell {
        private int element;
        private IntCell next;

        public IntCell(int element, IntCell next) {
            this.init(element, next);
        }

        public void init(int element, IntCell next) {
            this.element = element;
            this.next = next;
        }

        public String toString() {
            return this.element + "";
        }
    }
}

