% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/principalSubresultants.R
\name{principalSubresultants}
\alias{principalSubresultants}
\title{Principal subresultants of two polynomials}
\usage{
principalSubresultants(qspray1, qspray2, var = 1)
}
\arguments{
\item{qspray1, qspray2}{two \code{qspray} polynomials with at most nine
variables}

\item{var}{integer indicating with respect to which variable the
subresultants are desired (e.g. \code{1} for \code{x} and \code{2} for
\code{y})}
}
\value{
If both \code{qspray1} and \code{qspray2} are univariate polynomials,
  the function returns a vector of \code{bigq} rational numbers.
  Otherwise, it returns a list of \code{qspray} polynomials that do not
  involve the \code{var}-th variable.
}
\description{
Principal subresultants of two polynomials with rational
  coefficients.
}
\examples{
library(resultant)
x <- qlone(1)
y <- qlone(2)
p <- x^2 * y * (y^2 - 5*x + 6)
q <- x^2 * y * (3*y + 2)
principalSubresultants(p, q, var = 1) # should be 0, 0, non-zero, ...
principalSubresultants(p, q, var = 2) # should be 0, non-zero, ...
}
