% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_sa_item.R
\name{manipulate_sa_item}
\alias{manipulate_sa_item}
\alias{remove_sa_item}
\alias{remove_all_sa_item}
\alias{replace_sa_item}
\alias{add_new_sa_item}
\title{Manipulate SaItems}
\usage{
remove_sa_item(sap, pos = 1L)

remove_all_sa_item(sap)

replace_sa_item(sap, pos = 1L, sa_item)

add_new_sa_item(sap, sa_item)
}
\arguments{
\item{sap}{the SA-Processing.}

\item{pos}{the index of the \code{sa_item} to remove or to replace.}

\item{sa_item}{\code{sa_item} object.}
}
\value{
The functions \code{remove_sa_item()}, \code{remove_all_sa_item()}
and \code{replace_sa_item()} return invisibly (with \code{invisible()})
\code{TRUE} or an error.
The function \code{add_new_sa_item()} returns invisibly (with
\code{invisible()}) the updated \code{SA-Item}.
}
\description{
Functions to remove/replace/add a \code{sa_item} from/to a SA-Processing.
}
\examples{

library("RJDemetra")

sa_x13 <- jx13(series = ipi_c_eu[, "FR"])
sa_ts <- jtramoseats(series = ipi_c_eu[, "FR"])

wk <- new_workspace()
sap1 <- new_multiprocessing(workspace = wk, name = "sap-1")
add_sa_item(workspace = wk, multiprocessing = "sap-1",
            sa_obj = sa_x13, name = "X13")
add_sa_item(workspace = wk, multiprocessing = "sap-1",
            sa_obj = sa_ts, name = "TramoSeats")

sa_item1 <- get_object(x = sap1, pos = 1L)

remove_sa_item(sap = sap1, pos = 1L) # Remove the first sa-item
add_new_sa_item(sap = sap1, sa_item = sa_item1) # Add the sa-item at the end

# To replace the first sa_item by "sa_item1"
replace_sa_item(sap = sap1, pos = 1L, sa_item = sa_item1)
}
