% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup_names.R
\name{npn_lookup_names}
\alias{npn_lookup_names}
\title{Species Name Lookup}
\usage{
npn_lookup_names(name, type = "genus", fuzzy = FALSE)
}
\arguments{
\item{name}{A scientific or common name.}

\item{type}{One of \code{"common_name"}, \code{"genus"}, or \code{"species"}.}

\item{fuzzy}{Logical; if \code{TRUE}, uses fuzzy search via \code{\link[=agrep]{agrep()}}, if
\code{FALSE}, uses \code{\link[=grep]{grep()}}.}
}
\value{
A data frame with species ID numbers based on the name and type
parameters.
}
\description{
Look up species IDs by taxonomic or common name
}
\examples{
\dontrun{
npn_lookup_names(name = 'Pinus', type = 'genus')
npn_lookup_names(name = 'pine', type = 'common_name')
npn_lookup_names(name = 'bird', type = 'common_name', fuzzy = TRUE)
}
}
