% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_ggbiv.R
\name{plot_bivariate}
\alias{plot_bivariate}
\title{Bivariate Plot}
\usage{
plot_bivariate(
  tomic_table,
  x_var,
  y_var,
  color_var = NULL,
  shape_var = NULL,
  alpha_var = NULL,
  size_var = NULL
)
}
\arguments{
\item{tomic_table}{A table taken from a tidy (i.e., augmented measurements)
or triple omic dataset}

\item{x_var}{x-axis variable}

\item{y_var}{y-axis variable}

\item{color_var}{coloring variable (NULL to suppress coloring)}

\item{shape_var}{shape variable (NULL to suppress shape)}

\item{alpha_var}{alpha variable or numeric for constant alpha (NULL to suppress alpha)}

\item{size_var}{size variable or integer/numeric for constant size (NULL to suppress size)}
}
\value{
a ggplot2 grob
}
\description{
Create a scatter or boxplot from a tomic dataset.
}
\examples{
library(dplyr)

brauer_augmented <- brauer_2008_tidy \%>\%
  add_pcs(npcs = 5) \%>\%
  tomic_to("triple_omic")

tomic_table <- brauer_augmented$samples
plot_bivariate(tomic_table, "PC1", "PC2", "nutrient", "nutrient", 0.5, 10)
plot_bivariate(tomic_table, "PC1", "PC2", NULL)
plot_bivariate(tomic_table, "nutrient", "PC2", "nutrient")
}
