% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/annotations.R
\name{annotations}
\alias{annotations}
\title{Get all phenotypes, their variations, and how many users have data
		available for a given phenotype.}
\usage{
annotations(snp = NA, output = c("all", "plos", "mendeley", "snpedia",
  "metadata"), ...)
}
\arguments{
\item{snp}{SNP name.}

\item{output}{Name the source or sources you want annotations from (options
are: 'plos', 'mendeley', 'snpedia', 'metadata'). 'metadata' gives the
metadata for the response.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}.}
}
\value{
Data.frame of results.
}
\description{
Either return data.frame with all results, or output a list, then call
		the charicteristic by id (paramater = "id") or name (paramater = "characteristic").
}
\examples{
\dontrun{
# Get all data
annotations(snp = 'rs7903146', output = 'metadata') # get just the metadata
annotations(snp = 'rs7903146', output = 'plos') # just from plos
annotations(snp = 'rs7903146', output = 'snpedia') # just from snpedia
annotations(snp = 'rs7903146', output = 'all') # get all annotations
}
}

