% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{df_group_by}
\alias{df_group_by}
\title{Group a Data Frame by One or more Variables}
\usage{
df_group_by(data, ..., vars = NULL)
}
\arguments{
\item{data}{a data frame}

\item{...}{One or more unquoted expressions (or variable names) separated by
commas. Used to select a variable of interest.}

\item{vars}{a character vector containing the variable names of interest.}
}
\description{
Group a data frame by one or more variables. Supports standard
  and non standard evaluation.
}
\examples{

# Non standard evaluation
by_dose <- head(ToothGrowth) \%>\%
   df_group_by(dose)
by_dose

# Standard evaluation
head(ToothGrowth) \%>\%
   df_group_by(vars = c("dose", "supp"))
}
