% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sae4health-package.R
\name{sae4health-package}
\alias{sae4health-package}
\alias{sae4health}
\title{R Shiny App for Small Area Estimation of Health and Demographic Indicators}
\description{
The \strong{sae4health} package powers an \strong{R Shiny app} designed for small area estimation (SAE)
of health and demographic indicators in low- and middle-income countries (LMICs). It enables
subnational estimation and prevalence mapping for more than 150 binary indicators derived from
Demographic and Health Surveys (DHS), providing an intuitive interface for public health analysts,
policymakers, and researchers.
}
\details{
Built on the \strong{surveyPrev} package, \strong{sae4health} ensures methodological rigor in SAE analysis.
It offers guided model selection, automated model fitting, and interactive visualization,
making advanced statistical methods accessible to non-experts.


For comprehensive documentation on the \strong{sae4health} project and \strong{web-based app access}, visit:
\url{https://sae4health.stat.uw.edu/}

The latest development version of the package is maintained at:
\url{https://github.com/wu-thomas/sae4health}
}
\seealso{
\describe{
  \item{\strong{Getting Started:}}{\url{https://sae4health.stat.uw.edu/overview/project_overview/}}
  \item{\strong{Demo and Instruction Video:}}{\url{https://sae4health.stat.uw.edu/overview/youtube_app_demo/}}
  \item{\strong{Statistical Methods:}}{\url{https://sae4health.stat.uw.edu/method/approach_overview/}}
  \item{\strong{Visualization Gallery:}}{\url{https://sae4health.stat.uw.edu/gallery/visual_overview/}}
  \item{\strong{Recent Updates and News:}}{\url{https://sae4health.stat.uw.edu/blog/}}
}
}
\author{
\itemize{
  \item Yunhan Wu [\strong{Maintainer}] (\email{wu-thomas@outlook.com})
  \item Qianyu Dong (\email{qdong14@ucsc.edu})
  \item Zehang R Li (\email{lizehang@gmail.com})
  \item Jon Wakefield (\email{jonno@uw.edu})
}
}
