% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-parent-children.R
\name{similar_factor}
\alias{similar_factor}
\title{Factor similarity comparison class}
\usage{
similar_factor(scores, summary, methods, list_names, levels, digits = 3)
}
\arguments{
\item{scores}{List of similarity scores per method and comparison}

\item{summary}{Summary statistics by method and comparison}

\item{methods}{Character vector of methods used for comparison}

\item{list_names}{Character vector of names for the compared lists}

\item{levels}{Character vector of factor levels}

\item{digits}{Number of digits to round results (default: 3)}
}
\value{
An object of class "similar_factor" (which inherits from "similar") containing:
\itemize{
\item scores: List of factor similarity scores per method and comparison
\item summary: Summary statistics by method and comparison
\item methods: Character vector of factor comparison methods used (exact, order)
\item list_names: Character vector of names for the compared factor lists
\item digits: Number of digits to round results in output
\item levels: Character vector of factor levels used in the comparison
}
The factor similarity scores are normalized values between 0 and 1, where 1 indicates
identical factors and 0 indicates completely different factors based on the specific method used.
}
\description{
\code{similar_factor} is an S3 class for categorical/factor similarity comparisons.
}
\details{
This class extends the \code{similar} class and implements
categorical data-specific similarity comparison methods.
}
