## Do not edit this file manually.
## It has been automatically generated from *.org sources.
library(sarima)

context("sarima() - comparisons with tests in R's /stats/tests/arimaML.R")

## these are modified examples from arimaML.R 
## in "R/src/base/R-3.3.2/src/library/stats/tests/arimaML.R",
## the section starting with: 
###---------- PR#16278 --------------------------------------

test_that("sarima() matches  examples with x in arimaML.R", {

    ## simulate an arima(0,1,0) time series
    set.seed(0)
    n <- 5
    x <- cumsum(rnorm(n, sd=0.01))

    Vr <- var(diff(x))                 # 6.186e-5 : REML
    V. <- var(diff(x)) * (n-2) / (n-1) # 4.640e-5 : ML

    ## fit I(1) models with trend (no intercept)
    f00   <- arima0(x, c(0,1,0), method="ML", xreg = 1:n)
    fit1 <- arima(x, c(0,1,0), method="ML", xreg = 1:n)

            # all.equal(fit1$sigma2, V.)
            # fit1$nobs == n-1
            # all.equal(fit1$loglik, 14.28, tol=4e-4)
            # all.equal(f00$sigma2, fit1$sigma2)
            # all.equal(f00$loglik, fit1$loglik)
    
    expect_equal(fit1$sigma2, V.)
    expect_equal(fit1$nobs, n-1)
    expect_equal(fit1$loglik, 14.28, tol = 4e-4)
    expect_equal(f00$sigma2, fit1$sigma2)
    expect_equal(f00$loglik, fit1$loglik)
    
    ##Georgi
    g1 <- sarima(x ~ 0 + t | i(1), ss.method = "sarima")
    expect_equal(g1$sigma2, V.)
    expect_equal(g1$nobs, n - 1)
    expect_equal(g1$loglik, 14.28, tol = 4e-4)
    
    ## now compare g1 with fit1  (todo: relax the comparison?)
    expect_equal(as.vector(g1$coef), as.vector(fit1$coef))
    expect_equal(as.vector(g1$sigma2), as.vector(fit1$sigma2))
    expect_equal(g1$loglik, fit1$loglik)
    expect_equal(g1$aic, fit1$aic)

    ## use orthogonal polynomials
    fit1a <- arima (x, c(0,1,0), method="ML", xreg = poly(1:n, 1))
    g1a <- sarima(x ~ 0 + .p(1) | i(1), ss.method = "sarima")

    expect_equal(as.vector(g1a$coef), as.vector(fit1a$coef))
    expect_equal(as.vector(g1a$sigma2), as.vector(fit1a$sigma2))
    expect_equal(g1a$loglik, fit1a$loglik)
    expect_equal(g1a$aic, fit1a$aic)


    ## I(2) model, quadratic trend, same data
    fit2 <- arima(x, c(0,2,0), method = "ML", xreg = (1:n)^2)
    expect_equal(fit2$sigma2, 0.000109952342)
    expect_equal(fit2$loglik, 9.4163797)
    expect_equal(fit2$nobs, n - 2)
    
    g2 <- sarima(x ~ 0 + I(t^2) | i(2), ss.method = "sarima")
    expect_equal(as.vector(g2$coef), as.vector(fit2$coef))
    expect_equal(as.vector(g2$sigma2), as.vector(fit2$sigma2))
    expect_equal(g2$loglik, fit2$loglik)
    expect_equal(g2$aic, fit2$aic)
})

test_that("sarima() matches I(3) examples in arimaML.R", {

    ## "well"-fitting higher order model  {optim failed in R <= 3.0.1)
    ## x.   (different data); I(3) + third degree orthogonal polynomial
    ##                               (it is not (1:n)^3 etc, don't use .p()
    x. <- c(1:4, 3:-2, 2*(0:3), 4:5, 5:-4) / 32
    n2 <- length(x.)
    xr <- poly(x., 3)
    x. <- cumsum(cumsum(cumsum(x.))) + xr %*% 10^(0:2)
    
    fit3 <- arima (x., c(0,3,0), method = "ML", xreg = xr)
    ## don't use this, xr is not  over 1:n, see above
    ##     sarima(x. ~ 0 + .p(3) | i(3), ss.method = "sarima")
    ## using xr:
    g3 <- sarima(x. ~ 0 + .B(xr, 0) | i(3), ss.method = "sarima")
    g3a <- sarima(x. ~ 0 + .B(xr[, 1], 0) + .B(xr[, 2], 0) + .B(xr[, 3], 0) | i(3), 
                  ss.method = "sarima")
    g3_12 <- sarima(x. ~ 0 + .B(xr[, 1:2], 0) | i(3), ss.method = "sarima")

    expect_equal(fit3$nobs, n2 - 3)
    expect_equal(fit3$ sigma2, 0.00859843, tol = 1e-6)
    expect_equal(fit3$ loglik, 22.06043, tol = 1e-6)
    expect_equal(unname(coef(fit3)), c(0.70517, 9.9415, 100.106), tol = 1e-5)

    expect_equal(as.vector(g3$coef), as.vector(fit3$coef))
    expect_equal(as.vector(g3$sigma2), as.vector(fit3$sigma2))
    expect_equal(g3$loglik, fit3$loglik)
    expect_equal(g3$aic, fit3$aic)

    expect_equal(as.vector(g3a$coef), as.vector(fit3$coef))
    expect_equal(as.vector(g3a$sigma2), as.vector(fit3$sigma2))
    expect_equal(g3a$loglik, fit3$loglik)
    expect_equal(g3a$aic, fit3$aic)

    
    ## data: x.2 (as x. with some NA's)
    x.2 <- x.
    x.2[5:6] <- NA
    fit3N <- arima (x.2, c(0,3,0), method = "ML", xreg = xr)
    expect_equal(fit3N$nobs, n2 - 3 - 2) # ==  #{obs} - d - #{NA}
    expect_equal(fit3N$sigma2, 0.009297345, tol = 1e-6)
    expect_equal(fit3N$loglik, 16.73918,    tol = 1e-6)
    expect_equal(unname(coef(fit3N)), c(0.64904, 9.92660, 100.126), tol = 1e-5)

    g3N <- sarima(x.2 ~ 0 + .B(xr, 0) | i(3), ss.method = "sarima")
    g3Na <- sarima(x.2 ~ 0 + .B(xr[, 1], 0) + .B(xr[, 2], 0) + .B(xr[, 3], 0) | i(3),
                   ss.method = "sarima")
    g3N_12 <- sarima(x.2 ~ 0 + .B(xr[, 1:2], 0) | i(3), ss.method = "sarima")

    expect_equal(as.vector(g3N$coef), as.vector(fit3N$coef), tol = 1e-5)
    expect_equal(as.vector(g3N$sigma2), as.vector(fit3N$sigma2))
    expect_equal(g3N$loglik, fit3N$loglik)
    expect_equal(g3N$aic, fit3N$aic)

    expect_equal(as.vector(g3Na$coef), as.vector(fit3N$coef), tol = 1e-5)
    expect_equal(as.vector(g3Na$sigma2), as.vector(fit3N$sigma2))
    expect_equal(g3Na$loglik, fit3N$loglik)
    expect_equal(g3Na$aic, fit3N$aic)
  
})
