% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustStable.r
\name{clustStable}
\alias{clustStable}
\title{Create and compare multiple clustering runs on scRNA-seq data}
\usage{
clustStable(
  n_runs,
  seurat_obj,
  method = c("louvain", "leiden"),
  resolution = 0.8,
  dims = 1:10,
  n_cores = 1,
  verbose = TRUE,
  print_plot = TRUE,
  seeds = NULL
)
}
\arguments{
\item{n_runs}{Integer specifying the number of cluster assignments to generate (default: 100)}

\item{seurat_obj}{A Seurat object containing scRNA-seq data with a PCA reduction}

\item{method}{Character string specifying the clustering algorithm to use:
either "louvain" or "leiden"}

\item{resolution}{Numeric value specifying the clustering resolution parameter (default: 0.8)}

\item{dims}{Integer vector specifying which PCA dimensions to use (default: 1:10)}

\item{n_cores}{Integer specifying the number of CPU cores to use for parallelization (default: 1)}

\item{verbose}{Whether the function should print summary statistics as it calculates them}

\item{print_plot}{Whether the final violin plot should be automatically printed}

\item{seeds}{A set of seeds of length n_runs for creating clusters}
}
\value{
A list containing the following components:
\item{per_index_means}{Numeric vector of NMI values for each clustering iteration}
\item{ci}{Numeric vector containing the lower and upper bounds of the 95\% confidence interval}
\item{cluster_labels}{List of cluster assignments for each iteration}
}
\description{
Generate multiple clustering iterations on a Seurat object containing scRNA-seq data
using the provided dimensionality reduction. The function creates a shared nearest
neighbor (SNN) graph and assigns clusters using the specified algorithm, then calculates
stability metrics across iterations.
}
