% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{scaffold_py_function_wrapper}
\alias{scaffold_py_function_wrapper}
\title{Scaffold R wrappers for Python functions}
\usage{
scaffold_py_function_wrapper(
  python_function,
  r_function = NULL,
  file_name = NULL
)
}
\arguments{
\item{python_function}{Fully qualified name of Python function or class
constructor (e.g. \code{tf$nn$top_k})}

\item{r_function}{Name of R function to generate (defaults to name of Python
function if not specified)}

\item{file_name}{The file name to write the generated wrapper function to. If
\code{NULL}, the generated wrapper will only be printed out in the console.}
}
\description{
Scaffold R wrappers for Python functions
}
\note{
The generated wrapper will often require additional editing (e.g. to
convert Python list literals in the docs to R lists, to massage R numeric
values to Python integers via \code{as.integer} where required, etc.) so is
really intended as an starting point for an R wrapper rather than a wrapper
that can be used without modification.
}
\examples{
\donttest{

library(scaffolder)
library(tensorflow)

scaffold_py_function_wrapper("tf$nn$top_k")
}

}
