% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorecard.R
\name{scorecard_pmml}
\alias{scorecard_pmml}
\title{Scorecard to PMML}
\usage{
scorecard_pmml(card, save_name = NULL, model_name = "scorecard",
  model_version = NULL, description = "scorecard", copyright = NULL)
}
\arguments{
\item{card}{A data frame or a list of data frames. It's a scorecard object generated from the function \code{scorecard}.}

\item{save_name}{A string. The file name to save scorecard. Defaults to None.}

\item{model_name}{A name to be given to the PMML model.}

\item{model_version}{A string specifying the model version.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}
}
\description{
\code{scorecard_pmml} converts scorecard into PMML format.
}
\examples{
data("germancredit")
dtvf = var_filter(germancredit, y='creditability')
bins = woebin(dtvf, y='creditability')
card = scorecard2(bins, dtvf, y='creditability')

# export scorecard into pmml
cardpmml = scorecard_pmml(card)
# save pmml
# cardpmml = scorecard_pmml(card, save_name='scorecard', model_version='1.0')

}
