% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_xmile.R
\name{sim_specs}
\alias{sim_specs}
\title{Modify simulation specifications}
\usage{
sim_specs(
  sfm,
  method = "euler",
  start = "0.0",
  stop = "100.0",
  dt = "0.01",
  save_at = dt,
  save_from = start,
  seed = NULL,
  time_units = "s",
  language = "R"
)
}
\arguments{
\item{sfm}{Stock-and-flow model, object of class \code{\link[=xmile]{sdbuildR_xmile}}.}

\item{method}{Integration method. Defaults to "euler".}

\item{start}{Start time of simulation. Defaults to 0.}

\item{stop}{End time of simulation. Defaults to 100.}

\item{dt}{Timestep of solver; controls simulation accuracy. Smaller = more
accurate but slower. Defaults to 0.01.}

\item{save_at}{Timestep at which to save computed values; controls output size.
Must be >= dt. Use larger than dt to reduce memory without sacrificing accuracy.
Example: dt = 0.01, save_at = 1 gives accurate simulation but only saves
every 100th point. Defaults to dt (save everything).}

\item{save_from}{Time at which to start saving values. Use to discard initial
transient behavior. Must be >= start. Defaults to start.}

\item{seed}{Seed number to ensure reproducibility across runs in case of random elements. Must be an integer. Defaults to NULL (no seed).}

\item{time_units}{Simulation time unit, e.g. 's' (second). Defaults to "s".}

\item{language}{Coding language in which to simulate model. Either "R" or "Julia". Julia is necessary for using units or delay functions. Defaults to "R".}
}
\value{
A stock-and-flow model object of class \code{\link[=xmile]{sdbuildR_xmile}}
}
\description{
Simulation specifications are the settings that determine how the model is simulated, such as the integration method (i.e. solver), start and stop time, and timestep. Modify these specifications for an existing stock-and-flow model.
}
\examples{
sfm <- xmile("predator_prey") |>
  sim_specs(start = 0, stop = 50, dt = 0.1)
sim <- simulate(sfm)
plot(sim)

# Change the simulation method to "rk4"
sfm <- sim_specs(sfm, method = "rk4")

# Change the time units to "years", such that one time unit is one year
sfm <- sim_specs(sfm, time_units = "years")

# To save storage but not affect accuracy, use save_at and save_from
sfm <- sim_specs(sfm, save_at = 1, save_from = 10)
sim <- simulate(sfm)
head(as.data.frame(sim))

# Add stochastic initial condition but specify seed to obtain same result
sfm <- sim_specs(sfm, seed = 1) |>
  build(c("predator", "prey"), eqn = "runif(1, 20, 50)")

# Change the simulation language to Julia to use units
sfm <- sim_specs(sfm, language = "Julia")

}
\seealso{
\code{\link[=solvers]{solvers()}}
}
\concept{simulate}
