% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boruta.R
\name{boruta}
\alias{boruta}
\alias{plot.boruta}
\alias{print.boruta}
\title{Run the Boruta algorithm on a sem tree}
\usage{
boruta(
  model,
  data,
  control = NULL,
  predictors = NULL,
  maxRuns = 30,
  pAdjMethod = "none",
  alpha = 0.05,
  verbose = FALSE,
  quant = 1,
  ...
)
}
\arguments{
\item{model}{A template SEM. Same as in \code{semtree}.}

\item{data}{A dataframe to boruta on. Same as in \code{semtree}.}

\item{control}{A semforest control object to set forest parameters.}

\item{predictors}{An optional list of covariates. See semtree code example.}

\item{maxRuns}{Maximum number of boruta search cycles}

\item{pAdjMethod}{A value from \link[stats]{p.adjust.methods} defining a
multiple testing correction method}

\item{alpha}{p-value cutoff for decision making. Default .05}

\item{verbose}{Verbosity level for boruta processing
similar to the same argument in \link{semtree.control} and
\link{semforest.control}}

\item{quant}{Quantile for selection. Default 1.}

\item{\dots}{Optional parameters to undefined subfunctions}
}
\value{
A vim object with several elements that need work.
         Of particular note, `$importance` carries mean importance;
         `$decision` denotes Accepted/Rejected/Tentative;
         `$impHistory` has the entire varimp history; and
         `$details` has exit values for each parameter.
}
\description{
Grows a series of SEM Forests following the boruta algorithm to determine
   feature importance as moderators of the underlying model.
}
\seealso{
\code{\link{semtree}} \code{\link{semforest}}
}
\author{
Priyanka Paul, Timothy R. Brick, Andreas Brandmaier
}
\keyword{models}
\keyword{multivariate}
\keyword{tree}
