% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importRaster.R
\name{importRaster}
\alias{importRaster}
\title{Import generic raster file}
\usage{
importRaster(
  file = file.choose(),
  k = 1,
  kz = 1,
  dx = 0,
  dy = 0,
  destaggering = FALSE,
  variable = NULL,
  verbose = FALSE
)
}
\arguments{
\item{file}{The raster file to be imported.}

\item{k}{A numerical factor to be applied to x and y coordinates (default =
1).}

\item{kz}{A numerical factor to be applied to z values (default = 1).}

\item{dx}{Shifts x coordinates by dx (default = 0).}

\item{dy}{float. Shift y coordinates by dy (default = 0).}

\item{destaggering}{Use \code{TRUE} to apply destaggering to X and Y coordinates
(default = FALSE).}

\item{variable}{The name of the variable to be imported.}

\item{verbose}{If \code{TRUE}, prints out basic statistics (default = FALSE).}
}
\value{
It returns a dataframe with x, y and z columns.
}
\description{
The function import the first layer of a generic raster file. Data are
imported as an array of x, y, z columns.
}
\details{
Supported files include those managed by the \pkg{raster} package (as
netcdf),

Destaggering is useful for importing data from the SPRAY model and it is not
applied by default.

An optional summary output can be printed by setting the \code{verbose} parameter.

This function is based on the \code{terra} package and it can import any format
managed by it.
}
\examples{
\dontrun{
# Import binary (netcdf) file and convert coordinates from km to m,
# without destaggering:
mydata <- importRaster(file = "/path_to_file/filename.nc",
                       k = 1000,
                       destaggering = FALSE)

# Import binary (netcdf) file and convert coordinates from km to m,
# with shift of 100 m in both directions:
mydata <- importRaster(file = "/path_to_file/filename.nc",
                       k = 1000,
                       dx = 100,
                       dy = 100)
}
}
\seealso{
\code{\link[=importADSOBIN]{importADSOBIN()}}, \code{\link[=importSurferGrd]{importSurferGrd()}}
}
