% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_get_data.R
\name{sits_get_data}
\alias{sits_get_data}
\alias{sits_get_data.default}
\alias{sits_get_data.csv}
\alias{sits_get_data.shp}
\alias{sits_get_data.sf}
\alias{sits_get_data.sits}
\alias{sits_get_data.data.frame}
\title{Get time series from data cubes and cloud services}
\usage{
sits_get_data(cube, samples, ...)

\method{sits_get_data}{default}(cube, samples, ...)

\method{sits_get_data}{csv}(
  cube,
  samples,
  ...,
  bands = NULL,
  crs = "EPSG:4326",
  impute_fn = impute_linear(),
  multicores = 2,
  progress = FALSE
)

\method{sits_get_data}{shp}(
  cube,
  samples,
  ...,
  label = "NoClass",
  start_date = NULL,
  end_date = NULL,
  bands = NULL,
  impute_fn = impute_linear(),
  label_attr = NULL,
  n_sam_pol = 30,
  pol_avg = FALSE,
  pol_id = NULL,
  sampling_type = "random",
  multicores = 2,
  progress = FALSE
)

\method{sits_get_data}{sf}(
  cube,
  samples,
  ...,
  start_date = NULL,
  end_date = NULL,
  bands = NULL,
  impute_fn = impute_linear(),
  label = "NoClass",
  label_attr = NULL,
  n_sam_pol = 30,
  pol_avg = FALSE,
  pol_id = NULL,
  sampling_type = "random",
  multicores = 2,
  progress = FALSE
)

\method{sits_get_data}{sits}(
  cube,
  samples,
  ...,
  bands = NULL,
  crs = "EPSG:4326",
  impute_fn = impute_linear(),
  multicores = 2,
  progress = FALSE
)

\method{sits_get_data}{data.frame}(
  cube,
  samples,
  ...,
  start_date = NULL,
  end_date = NULL,
  bands = NULL,
  label = "NoClass",
  crs = "EPSG:4326",
  impute_fn = impute_linear(),
  multicores = 2,
  progress = FALSE
)
}
\arguments{
\item{cube}{Data cube from where data is to be retrieved.
(tibble of class "raster_cube").}

\item{samples}{Location of the samples to be retrieved.
Either a tibble of class "sits", an "sf" object,
the name of a shapefile or csv file, or
a data.frame with columns "longitude" and "latitude".}

\item{...}{Specific parameters for specific cases.}

\item{bands}{Bands to be retrieved - optional
(character vector).}

\item{crs}{Default crs for the samples
(character vector of length 1).}

\item{impute_fn}{Imputation function to remove NA.}

\item{multicores}{Number of threads to process the time series
(integer, with min = 1 and max = 2048).}

\item{progress}{Logical: show progress bar?}

\item{label}{Label to be assigned to the time series (optional)
(character vector of length 1).}

\item{start_date}{Start of the interval for the time series - optional
(Date in "YYYY-MM-DD" format).}

\item{end_date}{End of the interval for the time series - optional
(Date in "YYYY-MM-DD" format).}

\item{label_attr}{Attribute in the shapefile or sf object to be used
as a polygon label.
(character vector of length 1).}

\item{n_sam_pol}{Number of samples per polygon to be read
for POLYGON or MULTIPOLYGON shapefiles or sf objects
(single integer).}

\item{pol_avg}{Logical: summarize samples for each polygon?}

\item{pol_id}{ID attribute for polygons
(character vector of length 1)}

\item{sampling_type}{Spatial sampling type: random, hexagonal,
regular, or Fibonacci.}
}
\value{
A tibble of class "sits" with set of time series
<longitude, latitude, start_date, end_date, label>.
}
\description{
Retrieve a set of time series from a data cube or from
a time series service. Data cubes and puts it in a "sits tibble".
Sits tibbles are the main structures of sits package.
They contain both the satellite image time series and their metadata.
}
\note{
There are four ways of specifying data to be retrieved using the
\code{samples} parameter:
(a) CSV file: a CSV file with columns
\code{longitude}, \code{latitude},
\code{start_date}, \code{end_date} and \code{label} for each sample;
(b) SHP file: a shapefile in POINT or POLYGON geometry
containing the location of the samples and an attribute to be
used as label. Also, provide start and end date for the time series;
(c) sits object: A sits tibble;
(d) sf object: An \code{link[sf]{sf}} object with POINT or POLYGON geometry;
(e) data.frame: A data.frame with with mandatory columns
\code{longitude} and \code{latitude}.
}
\examples{
if (sits_run_examples()) {
    # reading a lat/long from a local cube
    # create a cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    raster_cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    samples <- tibble::tibble(longitude = -55.66738, latitude = -11.76990)
    point_ndvi <- sits_get_data(raster_cube, samples)
    #
    # reading samples from a cube based on a  CSV file
    csv_file <- system.file("extdata/samples/samples_sinop_crop.csv",
        package = "sits"
    )
    points <- sits_get_data(cube = raster_cube, samples = csv_file)

    # reading a shapefile from BDC (Brazil Data Cube)
    bdc_cube <- sits_cube(
            source = "BDC",
            collection = "CBERS-WFI-16D",
            bands = c("NDVI", "EVI"),
            tiles = c("007004", "007005"),
            start_date = "2018-09-01",
            end_date = "2018-10-28"
    )
    # define a shapefile to be read from the cube
    shp_file <- system.file("extdata/shapefiles/bdc-test/samples.shp",
            package = "sits"
    )
    # get samples from the BDC based on the shapefile
    time_series_bdc <- sits_get_data(
        cube = bdc_cube,
        samples = shp_file
    )
}

}
\author{
Gilberto Camara
}
