% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking_data.R
\name{calcular_incidencia}
\alias{calcular_incidencia}
\title{Calcular incidencia}
\usage{
calcular_incidencia(
  data_incidencia = NULL,
  cache = FALSE,
  ruta_dir = NULL,
  data_agrupada,
  poblacion = NULL,
  year = NULL,
  dpto = NULL,
  mpio = NULL,
  sex = NULL
)
}
\arguments{
\item{data_incidencia}{Un `data.frame` que contiene la población a riesgo o
las proyecciones poblaciones DANE. Si este parámetro está vacío, se importará
la población a riesgo o las proyecciones, dependiendo de la disponibilidad de
la información; su valor por defecto es `NULL`.}

\item{cache}{Un `logical` (`TRUE` o `FALSE`) que indica si la población a
riesgo o las proyecciones poblacionales DANE descargadas deben ser
almacenados en caché. Su valor por defecto es `FALSE`.}

\item{ruta_dir}{Un `character` (cadena de caracteres) que especifica la ruta
del directorio donde se almacenarán la población a riesgo o las proyecciones
poblacionales DANE. Su valor por defecto es `NULL`.}

\item{data_agrupada}{Un `data.frame` que contiene los datos de la enfermedad
agrupados por departamento o municipio y número de casos.}

\item{poblacion}{Un `character` (cadena de caracteres) con el tipo de
población para calcular la incidencia. Puede ser `"riesgo"` para la población
a riesgo o `"proyecciones"` para las proyecciones poblacionales DANE;
su valor por defecto es `NULL`.}

\item{year}{Un `numeric` (numérico) con el año que se debe tomar en la
población a riesgo o en las proyecciones poblacionales DANE; su valor por
defecto es `NULL`.}

\item{dpto}{Un `character` (cadena de caracteres) o `numeric` (numérico)
que contiene el código o nombre del departamento; su valor por
defecto es `NULL`.}

\item{mpio}{Un `character` (cadena de caracteres) o `numeric` (numérico)
que contiene el código o nombre del municipio; su valor por defecto
es `NULL`.}

\item{sex}{Un `character` (cadena de caracteres) que especifica el
sexo: `"F"` para Femenino y `"M"` para Masculino; su valor por defecto
es `NULL`.}
}
\value{
Un `numeric` con el cálculo de la incidencia para todo Colombia, un
departamento, municipio o sexo especifico.
}
\description{
Función que calcula la incidencia de una enfermedad o evento
para todo Colombia, un departamento o un municipio.
}
\examples{
\donttest{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
# Cálculo de la incidencia con proyecciones poblacionales por departamento
data_agrupada_mpios <- agrupar_mpio(data_limpia, dpto = "Antioquia")
if (interactive()) {
  calcular_incidencia(
    data_agrupada = data_agrupada_mpios,
    poblacion = "proyecciones",
    dpto = "05",
    year = 2020,
    cache = TRUE
  )
}
# Cálculo de la incidencia con proyecciones poblacionales por municipio
calcular_incidencia(
  data_agrupada = data_agrupada_mpios,
  poblacion = "proyecciones",
  dpto = "Antioquia",
  mpio = "05001",
  year = 2020,
  ruta_dir = tempdir()
)
# Cálculo de la incidencia con población a riesgo para Colombia
data_agrupada_dptos <- agrupar_dpto(data_limpia)
calcular_incidencia(
  poblacion = "riesgo",
  data_agrupada = data_agrupada_dptos,
  year = 2020,
  ruta_dir = tempdir()
)
}
}
