% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_nfl_players.R
\name{get_all_nfl_players}
\alias{get_all_nfl_players}
\title{Gather NFL Player Data}
\usage{
get_all_nfl_players(clean = FALSE)
}
\arguments{
\item{clean}{Specifies whether a data frame or the default list will be returned (logical)}
}
\value{
Returns a list or data frame containing information about the NFL players.
}
\description{
Gather all information concerning NFL players in list or data frame. Per Sleeper, this should be called once 
per day at most given the amount of data that it returns. By modifying the 'clean' parameter, either a
data frame will be returned or a list. When 'clean' is TRUE, a data frame will be returned. Note that while
most data is returned for the data frame, metadata will not be due to its dynamic nature. For example, 
metadata can be data frames on their own, so attempting to put them in a single data frame is not feasible. 
One might notice that a metadata column is present, but this is not properly cleanded since there could be NULLs, 
rookie years, injury overrides, or other miscellaneous columns that could add additional explanatory information. 
If either of these pieces will be problematic for you, it is recommended to keep 'clean' set to FALSE and parse 
the default list as you see fit.
}
\examples{
\dontrun{get_all_nfl_players(clean = FALSE)}
\dontrun{get_all_nfl_players(clean = TRUE)}

}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, December 2021
}
\keyword{nfl}
\keyword{players}
