% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slickR.R
\name{slickR}
\alias{slickR}
\title{slick.js image carousel htmlwidget}
\usage{
slickR(obj, slideId = "baseDiv", slideIdx = list(1:length(obj)),
  slideType = c("img"), slickOpts = list(dots = TRUE),
  padding = rep("1\%", length(obj)), objLinks = NULL,
  synchSlides = NULL, dotObj = NULL, width = NULL, height = NULL,
  elementId = NULL)
}
\arguments{
\item{obj}{character, vector of path or url to images}

\item{slideId}{character, id of slide}

\item{slideIdx}{list, numeric indices which images are mapped to which slider}

\item{slideType}{character, type of object to put in slide}

\item{slickOpts}{list, attributes for each slider, see details 
\lifecycle{soft-deprecated}}

\item{padding}{character, percent of width between each image in the 
carousel for each slider, Default: '1\%'}

\item{objLinks}{list, Named list corresponding to slideId containing links to attach to each element.
If NULL then no links applied, Default: NULL}

\item{synchSlides}{data.frame, rowwise pairs of slideId names of sliders are
synchronized \lifecycle{soft-deprecated}}

\item{dotObj}{list, character vectors of url or images to replace dots 
with (see details)}

\item{width}{character, width of htmlwidget}

\item{height}{character, height of htmlwidget}

\item{elementId}{character, id tag of htmlwidget}
}
\description{
use slick.js library in R
}
\details{
slick.js \url{http://kenwheeler.github.io/slick/} is an image 
carousel javascript library. To find all the attributes
that can be used please refer to the link. To create more than one carousel 
input the attributes into a nested list eg 
slickOpts=list(list(slidesToShow=1,slidestoScroll=1,arrows=F,fade=T),
list(slidesToShow=3,slidesToScroll=1,dots=T,focusOnSelect=T,centerMode=T)). 
It is possible to synchronize the slides
through the slickOpts calls, using asNavFor attribute. To replace the dots 
with icons use the dotObj argument to pass in the icon
images and in the slickOpts add a customPaging attribute with the 
appropriate JS(.) function call. The slideType accepts the type 
of html DOM you want to be in the slide, eg img, iframe.
}
\examples{


if(interactive()){
  slickR(obj=nba_team_logo$uri)

# synching 3 groups

# creating groups
sx1 <- as.numeric(grepl('C',nba_team_logo$uri,ignore.case = FALSE))
sx2 <- as.numeric(grepl('D',nba_team_logo$uri,ignore.case = FALSE))*2
sx3 <- sx1 + sx2

# split into list of size 3
sIdx <- lapply(split(nba_team_logo$uri,sx3),function(x) match(x,nba_team_logo$uri))

# synching logic (a,b) and (a,c)
groups <- expand.grid(list('a',c('b','c')),stringsAsFactors = FALSE)

slickR(obj = nba_team_logo$uri,
       slideId = c('a','b','c'),
       slideIdx = sx,
       slideType = rep('img',3),
       synchSlides = groups,
       height = 100)

}
}
